/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.param;

import com.mulesoft.connectors.x12.extension.api.config.CharacterEncoding;
import com.mulesoft.connectors.x12.extension.api.config.CharacterRestriction;
import com.mulesoft.connectors.x12.extension.api.config.X12Variation;
import java.nio.charset.Charset;
import java.util.List;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class DocumentParams {
    @Parameter
    @Optional(defaultValue="X12")
    @DisplayName(value="Form and validation")
    @Placement(order=0)
    private X12Variation formValidation;
    @Parameter
    @Optional
    @DisplayName(value="Schema definitions")
    @Placement(order=1)
    @Summary(value="List of paths (either file system or classpath) for schemas to be used by connector")
    private List<String> schemas;
    @Parameter
    @Optional(defaultValue="PLATFORM")
    @DisplayName(value="Character encoding")
    @Placement(order=3)
    @Summary(value="Character encoding used for both send and receive messages")
    private CharacterEncoding characterEncoding;
    @Parameter
    @Optional(defaultValue="EXTENDED")
    @DisplayName(value="Character set")
    @Placement(order=4)
    @Summary(value="Characters allowed in string data")
    private CharacterRestriction stringCharacterSet;
    @Parameter
    @Optional
    @DisplayName(value="Substitution character")
    @Placement(order=5)
    @Summary(value="Substitution character used to replace invalid characters in string values")
    private String stringSubstitutionChar;
    @Parameter
    @Optional
    @DisplayName(value="Version identifier suffix")
    @Placement(order=6)
    @Summary(value="Version identifier code suffix for group (GS segment)")
    private String versionIdentifierSuffix;
    private Charset charset;

    public X12Variation getFormValidation() {
        return this.formValidation;
    }

    public void setFormValidation(X12Variation formValidation) {
        this.formValidation = formValidation;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public CharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(CharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public CharacterRestriction getStringCharacterSet() {
        return this.stringCharacterSet;
    }

    public void setStringCharacterSet(CharacterRestriction stringCharacterSet) {
        this.stringCharacterSet = stringCharacterSet;
    }

    public String getStringSubstitutionChar() {
        return this.stringSubstitutionChar;
    }

    public void setStringSubstitutionChar(String stringSubstitutionChar) {
        this.stringSubstitutionChar = stringSubstitutionChar;
    }

    public String getVersionIdentifierSuffix() {
        return this.versionIdentifierSuffix;
    }

    public void setVersionIdentifierSuffix(String versionIdentifierSuffix) {
        this.versionIdentifierSuffix = versionIdentifierSuffix;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void validate(String muleEncoding) {
        if (CharacterEncoding.PLATFORM == this.characterEncoding) {
            if (muleEncoding == null) {
                throw new RuntimeException("No default encoding for platform");
            }
            this.charset = Charset.forName(muleEncoding);
        } else {
            this.charset = this.characterEncoding.characterSet;
        }
        if (this.stringSubstitutionChar != null && this.stringSubstitutionChar.length() != 1) {
            throw new RuntimeException("stringSubstitutionChar value must be a single character, if used");
        }
    }
}

