/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12pre.extension.internal.config;

import com.mulesoft.connectors.x12pre.extension.api.config.CharacterEncoding;
import com.mulesoft.connectors.x12pre.extension.internal.operation.X12Operations;
import java.nio.charset.Charset;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Operations(value={X12Operations.class})
@Configuration(name="config")
public class X12Config
implements ConnectorConfig,
Initialisable {
    @Parameter
    @Optional(defaultValue="PLATFORM")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Character encoding")
    @Placement(order=2)
    @Summary(value="Character encoding used for both send and receive messages")
    private CharacterEncoding characterEncoding;
    @DefaultEncoding
    private String muleEncoding;
    private Charset charset;

    public CharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(CharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void initialise() throws InitialisationException {
        if (CharacterEncoding.PLATFORM == this.characterEncoding) {
            if (this.muleEncoding == null) {
                throw new RuntimeException("No default encoding for platform");
            }
            this.charset = Charset.forName(this.muleEncoding);
        } else {
            this.charset = this.characterEncoding.characterSet;
        }
    }
}

