/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class SecurityRequirement {
    @Parameter
    @Optional
    @DisplayName(value="Security Scheme Name")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The name of the security scheme")
    private String securitySchemeName;
    @Parameter
    @Optional
    @DisplayName(value="Required Scopes")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="List of required scopes for this security scheme")
    private List<String> scopes;

    public String getSecuritySchemeName() {
        return this.securitySchemeName;
    }

    public void setSecuritySchemeName(String securitySchemeName) {
        this.securitySchemeName = securitySchemeName;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public SecurityRequirement copy() {
        SecurityRequirement copy = new SecurityRequirement();
        copy.securitySchemeName = this.securitySchemeName;
        if (this.scopes != null) {
            copy.scopes = new ArrayList<String>(this.scopes);
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityRequirement that = (SecurityRequirement)o;
        return Objects.equals(this.securitySchemeName, that.securitySchemeName) && Objects.equals(this.scopes, that.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.securitySchemeName, this.scopes);
    }
}

