/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card;

import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;

public abstract class SecurityScheme {
    @Parameter
    @DisplayName(value="Security Scheme Name")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The name of the security scheme")
    @Placement(order=1)
    private String securitySchemeName;
    @Parameter
    @Optional
    @Text
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Description")
    @Summary(value="Description of this security scheme")
    @Placement(order=2)
    private String description;

    public void setSecuritySchemeName(String securitySchemeName) {
        if (securitySchemeName == null || securitySchemeName.trim().isEmpty()) {
            throw new IllegalArgumentException("Security scheme name cannot be null or empty");
        }
        this.securitySchemeName = securitySchemeName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSecuritySchemeName() {
        return this.securitySchemeName;
    }

    public abstract String getType();

    public String getDescription() {
        return this.description;
    }

    public abstract SecurityScheme copy();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityScheme that = (SecurityScheme)o;
        return Objects.equals(this.securitySchemeName, that.securitySchemeName) && Objects.equals(this.description, that.description) && Objects.equals(this.getType(), that.getType());
    }

    public int hashCode() {
        return Objects.hash(this.securitySchemeName, this.description, this.getType());
    }
}

