/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.mulesoft.connectors.a2a.api.model.card.SecurityScheme;
import com.mulesoft.connectors.a2a.api.model.card.security.ApiKeyLocation;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ApiKeySecurityScheme
extends SecurityScheme {
    private final String type = "apiKey";
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Name")
    @Summary(value="The name of the header, query or cookie parameter to be used")
    private String name;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="In")
    @Summary(value="The location of the API key (query, header, cookie)")
    private ApiKeyLocation in;

    @Override
    public ApiKeySecurityScheme copy() {
        ApiKeySecurityScheme copy = new ApiKeySecurityScheme();
        copy.setSecuritySchemeName(this.getSecuritySchemeName());
        copy.setDescription(this.getDescription());
        copy.name = this.name;
        copy.in = this.in;
        return copy;
    }

    @Override
    public String getType() {
        return "apiKey";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name is required and cannot be null or empty");
        }
        this.name = name;
    }

    public ApiKeyLocation getIn() {
        return this.in;
    }

    public void setIn(ApiKeyLocation in) {
        if (in == null) {
            throw new IllegalArgumentException("In location is required and cannot be null");
        }
        this.in = in;
    }

    @JsonGetter(value="in")
    public String getInJson() {
        return this.in != null ? this.in.getValue() : null;
    }

    @JsonSetter(value="in")
    public void setInJson(String inValue) {
        this.setInValue(inValue);
    }

    public void setInValue(String inValue) {
        if (inValue == null || inValue.trim().isEmpty()) {
            throw new IllegalArgumentException("In location is required and cannot be null or empty");
        }
        ApiKeyLocation location = ApiKeyLocation.fromValue(inValue);
        if (location == null) {
            throw new IllegalArgumentException("Invalid location value: " + inValue + ". Must be one of: header, query, cookie");
        }
        this.in = location;
    }

    public String getInValue() {
        return this.getInJson();
    }

    public String getInValueForDataWeave() {
        return this.in != null ? this.in.getValue() : null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ApiKeySecurityScheme) {
            ApiKeySecurityScheme apiKeySecurityScheme = (ApiKeySecurityScheme)object;
            return super.equals(object) && Objects.equals(this.name, apiKeySecurityScheme.name) && Objects.equals((Object)this.in, (Object)apiKeySecurityScheme.in);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, this.in});
    }
}

