/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.mulesoft.connectors.a2a.api.model.card.SecurityScheme;
import com.mulesoft.connectors.a2a.api.model.card.security.HttpSchemeType;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class HttpSecurityScheme
extends SecurityScheme {
    private final String type = "http";
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Scheme")
    @Summary(value="The HTTP Authorization scheme (basic, bearer, digest, etc.)")
    private HttpSchemeType scheme;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Bearer Format")
    @Summary(value="A hint to the client to identify how the bearer token is formatted (JWT, etc.)")
    private String bearerFormat;

    @Override
    public HttpSecurityScheme copy() {
        HttpSecurityScheme copy = new HttpSecurityScheme();
        copy.setSecuritySchemeName(this.getSecuritySchemeName());
        copy.setDescription(this.getDescription());
        copy.scheme = this.scheme;
        copy.bearerFormat = this.bearerFormat;
        return copy;
    }

    @Override
    public String getType() {
        return "http";
    }

    public HttpSchemeType getScheme() {
        return this.scheme;
    }

    public void setScheme(HttpSchemeType scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme is required and cannot be null");
        }
        this.scheme = scheme;
    }

    public void setSchemeValue(String schemeValue) {
        if (schemeValue == null || schemeValue.trim().isEmpty()) {
            throw new IllegalArgumentException("Scheme is required and cannot be null or empty");
        }
        HttpSchemeType schemeType = HttpSchemeType.fromValue(schemeValue);
        if (schemeType == null) {
            throw new IllegalArgumentException("Invalid scheme value: " + schemeValue);
        }
        this.scheme = schemeType;
    }

    @JsonSetter(value="scheme")
    public void setSchemeJson(String schemeValue) {
        this.setSchemeValue(schemeValue);
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public void setBearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    public String getSchemeValue() {
        return this.getSchemeJson();
    }

    public String getSchemeValueForDataWeave() {
        return this.scheme != null ? this.scheme.getValue() : null;
    }

    @JsonGetter(value="scheme")
    public String getSchemeJson() {
        return this.scheme != null ? this.scheme.getValue() : null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof HttpSecurityScheme) {
            HttpSecurityScheme httpSecurityScheme = (HttpSecurityScheme)object;
            return super.equals(object) && Objects.equals((Object)this.scheme, (Object)httpSecurityScheme.scheme) && Objects.equals(this.bearerFormat, httpSecurityScheme.bearerFormat);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.scheme, this.bearerFormat});
    }
}

