/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Flow;
import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="Implicit Oauth2 Flows")
public class ImplicitOauth2Flows
extends Oauth2Flow {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Authorization URL")
    @Summary(value="The authorization URL to be used for this flow")
    private String authorizationUrl;
    private final String type = "implicit";

    @Override
    public String getType() {
        return "implicit";
    }

    @Override
    public ImplicitOauth2Flows copy() {
        ImplicitOauth2Flows copy = new ImplicitOauth2Flows();
        copy.authorizationUrl = this.authorizationUrl;
        copy.setRefreshUrl(this.getRefreshUrl());
        if (this.getOauth2Scopes() != null) {
            copy.setOauth2Scopes(this.getOauth2Scopes().stream().map(Oauth2Scope::copy).collect(Collectors.toList()));
        }
        return copy;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ImplicitOauth2Flows) {
            ImplicitOauth2Flows implicitOauth2Flows = (ImplicitOauth2Flows)object;
            return super.equals(object) && Objects.equals(this.authorizationUrl, implicitOauth2Flows.authorizationUrl) && Objects.equals(this.getOauth2Scopes(), implicitOauth2Flows.getOauth2Scopes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.authorizationUrl);
    }
}

