/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.mulesoft.connectors.a2a.api.model.card.security.AuthorizationCodeOauth2Flows;
import com.mulesoft.connectors.a2a.api.model.card.security.ClientCredentialsOauth2Flows;
import com.mulesoft.connectors.a2a.api.model.card.security.ImplicitOauth2Flows;
import com.mulesoft.connectors.a2a.api.model.card.security.PasswordOauth2Flows;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="OAuth2 Flows")
public class Oauth2Flows {
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Implicit Flow")
    @Summary(value="Configuration for implicit OAuth2 flow")
    private ImplicitOauth2Flows implicit;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Password Flow")
    @Summary(value="Configuration for password OAuth2 flow")
    private PasswordOauth2Flows password;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Client Credentials Flow")
    @Summary(value="Configuration for client credentials OAuth2 flow")
    private ClientCredentialsOauth2Flows clientCredentials;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Authorization Code Flow")
    @Summary(value="Configuration for authorization code OAuth2 flow")
    private AuthorizationCodeOauth2Flows authorizationCode;

    public Oauth2Flows copy() {
        Oauth2Flows copy = new Oauth2Flows();
        copy.implicit = this.implicit != null ? this.implicit.copy() : null;
        copy.password = this.password != null ? this.password.copy() : null;
        copy.clientCredentials = this.clientCredentials != null ? this.clientCredentials.copy() : null;
        copy.authorizationCode = this.authorizationCode != null ? this.authorizationCode.copy() : null;
        return copy;
    }

    public ImplicitOauth2Flows getImplicit() {
        return this.implicit;
    }

    public void setImplicit(ImplicitOauth2Flows implicit) {
        this.implicit = implicit;
    }

    public PasswordOauth2Flows getPassword() {
        return this.password;
    }

    public void setPassword(PasswordOauth2Flows password) {
        this.password = password;
    }

    public ClientCredentialsOauth2Flows getClientCredentials() {
        return this.clientCredentials;
    }

    public void setClientCredentials(ClientCredentialsOauth2Flows clientCredentials) {
        this.clientCredentials = clientCredentials;
    }

    public AuthorizationCodeOauth2Flows getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(AuthorizationCodeOauth2Flows authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public boolean equals(Object object) {
        if (object instanceof Oauth2Flows) {
            Oauth2Flows oauth2Flows = (Oauth2Flows)object;
            return Objects.equals(this.implicit, oauth2Flows.implicit) && Objects.equals(this.password, oauth2Flows.password) && Objects.equals(this.clientCredentials, oauth2Flows.clientCredentials) && Objects.equals(this.authorizationCode, oauth2Flows.authorizationCode);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.implicit, this.password, this.clientCredentials, this.authorizationCode);
    }
}

