/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;

public class Oauth2Scope {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Scope Name")
    @Summary(value="The name of the OAuth2 scope")
    private String name;
    @Parameter
    @Text
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Description")
    @Summary(value="Description of this OAuth2 scope")
    private String description;

    public Oauth2Scope copy() {
        Oauth2Scope copy = new Oauth2Scope();
        copy.name = this.name;
        copy.description = this.description;
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Scope name cannot be null or empty");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object object) {
        if (object instanceof Oauth2Scope) {
            Oauth2Scope oauth2Scope = (Oauth2Scope)object;
            return Objects.equals(this.name, oauth2Scope.name) && Objects.equals(this.description, oauth2Scope.description);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }
}

