/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Flow;
import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="Password Oauth2 Flows")
public class PasswordOauth2Flows
extends Oauth2Flow {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Token URL")
    @Summary(value="The token URL to be used for this flow")
    private String tokenUrl;
    private final String type = "password";

    @Override
    public String getType() {
        return "password";
    }

    @Override
    public PasswordOauth2Flows copy() {
        PasswordOauth2Flows copy = new PasswordOauth2Flows();
        copy.tokenUrl = this.tokenUrl;
        copy.setRefreshUrl(this.getRefreshUrl());
        if (this.getOauth2Scopes() != null) {
            copy.setOauth2Scopes(this.getOauth2Scopes().stream().map(Oauth2Scope::copy).collect(Collectors.toList()));
        }
        return copy;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PasswordOauth2Flows) {
            PasswordOauth2Flows passwordOauth2Flows = (PasswordOauth2Flows)object;
            return super.equals(object) && Objects.equals(this.tokenUrl, passwordOauth2Flows.tokenUrl) && Objects.equals(this.getOauth2Scopes(), passwordOauth2Flows.getOauth2Scopes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokenUrl);
    }
}

