/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.client.connection;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.api.model.transport.ResponseAttributes;
import com.mulesoft.connectors.a2a.internal.client.helper.AgentCardHelper;
import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.error.exception.AgentCardDiscoveryException;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.tracing.TracingUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A2AClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(A2AClient.class);
    private String baseUrl;
    private final HttpClient httpClient;
    private final HttpRequestAuthentication authentication;
    private final HttpRequestOptions requestOptions;
    private final JsonRpcSerializer serializer;
    private final MultiMap<String, String> defaultHeaders;

    public A2AClient(String baseUrl, int responseTimeout, HttpClient httpClient, HttpRequestAuthentication authentication, MultiMap<String, String> defaultHeaders, JsonRpcSerializer serializer) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.httpClient = httpClient;
        this.serializer = serializer;
        this.defaultHeaders = defaultHeaders != null ? MultiMap.unmodifiableMultiMap(defaultHeaders) : MultiMap.emptyMultiMap();
        HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptions.builder().responseTimeout(responseTimeout);
        if (authentication instanceof HttpAuthentication) {
            HttpAuthentication auth = (HttpAuthentication)authentication;
            optionsBuilder.authentication(auth);
            this.authentication = null;
        } else {
            this.authentication = authentication;
        }
        this.requestOptions = optionsBuilder.build();
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    public CompletableFuture<Result<String, ResponseAttributes>> sendTask(InputStream task, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("tasks/send", task, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> sendMessage(InputStream message, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("message/send", message, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getTask(InputStream query, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("tasks/get", query, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getCard(boolean useExtendedCard, DistributedTraceContextManager traceContextManager) {
        return this.getAgentCard(useExtendedCard, false, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getCard(boolean useExtendedCard, boolean setBaseUrl, DistributedTraceContextManager traceContextManager) {
        return this.getAgentCard(useExtendedCard, setBaseUrl, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> cancelTask(InputStream taskId, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("tasks/cancel", taskId, traceContextManager);
    }

    private CompletableFuture<Result<String, ResponseAttributes>> doRequest(String method, Object params, DistributedTraceContextManager traceContextManager) {
        return this.doRequest(HttpConstants.Method.POST, "", method, params, traceContextManager);
    }

    private CompletableFuture<Result<String, ResponseAttributes>> doRequest(HttpConstants.Method httpMethod, String uri, String method, Object params, DistributedTraceContextManager traceContextManager) {
        CompletableFuture<Result<String, ResponseAttributes>> future = new CompletableFuture<Result<String, ResponseAttributes>>();
        HttpRequestBuilder requestBuilder = ((HttpRequestBuilder)this.newRequestBuilder().uri(this.baseUrl + uri).addHeader("Content-Type", "application/json")).method(httpMethod);
        this.defaultHeaders.toListValuesMap().forEach((arg_0, arg_1) -> ((HttpRequestBuilder)requestBuilder).addHeaders(arg_0, arg_1));
        TracingUtils.propagateTraceContext(requestBuilder, traceContextManager);
        if (httpMethod == HttpConstants.Method.POST) {
            requestBuilder.entity((HttpEntity)new InputStreamHttpEntity(this.serializer.writeJsonRequest(method, params)));
        }
        HttpRequest request = requestBuilder.build();
        TracingUtils.traceOutboundRequest(traceContextManager, request);
        this.httpClient.sendAsync(request, this.requestOptions).whenComplete((response, e) -> {
            try {
                JsonRpcError rpcError;
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                    return;
                }
                int statusCode = response.getStatusCode();
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                if (statusCode == HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()) {
                    future.completeExceptionally((Throwable)new ModuleException(content, (ErrorTypeDefinition)A2AErrorTypes.UNAUTHORIZED));
                    return;
                }
                if (httpMethod == HttpConstants.Method.GET) {
                    future.complete(Result.builder().output((Object)content).attributes((Object)new ResponseAttributes(statusCode, (MultiMap<String, String>)response.getHeaders(), response.getReasonPhrase())).build());
                    return;
                }
                if ((statusCode >= 400 || statusCode == 200 && content.contains("\"error\":")) && (rpcError = this.serializer.getJsonResponseError(content)) != null) {
                    future.completeExceptionally((Throwable)new ModuleException(rpcError.codeAndMessage(), (ErrorTypeDefinition)A2AErrorTypes.fromRpcErrorCode(rpcError.getCode())));
                    return;
                }
                if (statusCode >= 200 && statusCode < 300) {
                    future.complete(Result.builder().output((Object)this.serializer.getJsonResponseResult(content)).attributes((Object)new ResponseAttributes(response.getStatusCode(), (MultiMap<String, String>)response.getHeaders(), response.getReasonPhrase())).build());
                } else {
                    future.completeExceptionally((Throwable)new ModuleException("Invalid response status code: " + statusCode, (ErrorTypeDefinition)A2AErrorTypes.INTERNAL_ERROR));
                }
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    private HttpRequestBuilder newRequestBuilder() {
        HttpRequestBuilder builder = HttpRequest.builder((boolean)true);
        if (this.authentication != null) {
            try {
                this.authentication.authenticate(builder);
            }
            catch (MuleException e) {
                throw new ModuleException((ErrorTypeDefinition)A2AErrorTypes.INTERNAL_ERROR, (Throwable)e);
            }
        }
        return builder;
    }

    private CompletableFuture<Result<String, ResponseAttributes>> getCardResponse(boolean useExtendedCard, DistributedTraceContextManager traceContextManager) {
        if (!useExtendedCard) {
            return this.doRequest(HttpConstants.Method.GET, ".well-known/agent.json", null, null, traceContextManager);
        }
        return this.doRequest(HttpConstants.Method.GET, "agent/authenticatedExtendedCard", null, null, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getAgentCard(boolean useExtendedCard, boolean setBaseUrl, DistributedTraceContextManager traceContextManager) {
        CompletableFuture<Result<String, ResponseAttributes>> future = new CompletableFuture<Result<String, ResponseAttributes>>();
        try {
            URI requestUri = AgentCardHelper.validateServerUrl(this.baseUrl);
            this.getCardResponse(useExtendedCard, traceContextManager).whenComplete((result, throwable) -> {
                try {
                    if (throwable != null) {
                        future.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    AgentCard agentCard = AgentCardHelper.handleAgentCardResponse(requestUri, (Result<String, ResponseAttributes>)result, this.serializer);
                    if (setBaseUrl) {
                        this.setBaseUrl(agentCard.getUrl());
                        LOGGER.debug("Using service URL from agent card: {}", (Object)agentCard.getUrl());
                    }
                    future.complete((Result<String, ResponseAttributes>)result);
                }
                catch (Exception e) {
                    if (e instanceof AgentCardDiscoveryException.InvalidAgentCardException) {
                        future.completeExceptionally((Throwable)new ModuleException(e.getMessage(), (ErrorTypeDefinition)A2AErrorTypes.INVALID_AGENT_CARD));
                    }
                    future.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public String getServiceUrl() {
        return this.baseUrl;
    }
}

