/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.protocol;

import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import java.io.InputStream;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.util.IOUtils;

public class A2AProtocolSerializer
implements Initialisable {
    private static final DataType RESULT_DATA_TYPE = DataType.fromType(JsonRpcResult.class);
    @Inject
    private ExpressionManager expressionManager;
    private DwConverter requestMessageTransformer;
    private DwConverter responseMessageTransformer;
    private DwConverter resultParser;
    private DwConverter taskQueryParamsExtractor;
    private DwConverter taskHistoryTransformer;

    public String getJsonMessageFromResult(String json) {
        return this.responseMessageTransformer.evaluateAsString(json, DataType.JSON_STRING);
    }

    public JsonRpcResult parseResult(String json) {
        return (JsonRpcResult)this.resultParser.evaluate(json, RESULT_DATA_TYPE);
    }

    public String getJsonMessageFromRequest(String json) {
        return this.requestMessageTransformer.evaluateAsString(json, DataType.JSON_STRING);
    }

    public JsonRpcResult getTaskQueryParams(String params) {
        return (JsonRpcResult)this.taskQueryParamsExtractor.evaluate(params, RESULT_DATA_TYPE);
    }

    public String transformTaskHistoryResponse(String taskHistoryJson, int historyLength) {
        return this.taskHistoryTransformer.evaluateAsStringWithBinding(taskHistoryJson, DataType.JSON_STRING, (value, builder) -> {
            builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING));
            builder.addBinding("historyLength", new TypedValue((Object)historyLength, DataType.fromType(Integer.class)));
        });
    }

    public void initialise() {
        this.responseMessageTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\nif (payload.result.kind == \"task\")\n    do {\n       var statusMessage = payload.result.status.message default {}\n       ---\n       {\n    taskId: payload.result.id,\n    contextId: payload.result.contextId,\n           messageId: statusMessage.messageId,\n           role: statusMessage.role,\n           parts: statusMessage.parts\n       }\n   }\nelse {\n    // Handle Message Object response\n    taskId: payload.result.taskId,\n    contextId: payload.result.contextId,\n    role: payload.result.role,\n    parts: payload.result.parts,\n    messageId: payload.result.messageId\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.resultParser = new DwConverter("output application/java\n---\n{\n  result: if (payload.result.kind == \"task\") {\n            id: payload.result.id,\n            contextId: payload.result.contextId,\n            status: write(payload.result.status, \"json\") as String\n          } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.TaskObject\"}\n          else if (payload.result.kind == \"message\") {\n            taskId: payload.result.taskId,\n            messageId: payload.result.messageId\n          } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.MessageObject\"}\n          else\n            null,\n  resultJson: write(payload.result, \"json\") as String,\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.requestMessageTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\npayload.message\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.taskQueryParamsExtractor = new DwConverter("output application/java\n---\n{\n    result: {\n        id: payload.id,\n        historyLength: payload.historyLength default 0\n    } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.request.TaskQueryParams\"},\n    resultJson: write(payload, \"json\") as String\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.taskHistoryTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n    id: payload.task.id,\n    contextId: payload.task.contextId,\n    status: payload.task.status,\n    history: if (payload.history != null) do {\n        var minHistoryLength = min([historyLength, (payload.historyLength)])\n        ---\n        payload.history[(sizeOf(payload.history) - minHistoryLength) to (sizeOf(payload.history) - 1)]\n    } else [],\n    artifacts: payload.task.artifacts,\n    kind: payload.task.kind\n}\n", (value, builder) -> {
            builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING));
            builder.addBinding("historyLength", new TypedValue((Object)0, DataType.fromType(Integer.class)));
        });
    }

    private class DwConverter {
        private final CompiledExpression expression;
        private final BiConsumer<Object, BindingContext.Builder> bindingConfigurer;

        private DwConverter(String expression, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this(expression, null, bindingConfigurer);
        }

        private DwConverter(String expression, Object defaultBindingValue, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this.bindingConfigurer = bindingConfigurer;
            this.expression = A2AProtocolSerializer.this.expressionManager.compile(expression, this.bind(defaultBindingValue));
        }

        private BindingContext bind(Object value) {
            BindingContext.Builder builder = BindingContext.builder();
            this.bindingConfigurer.accept(value, builder);
            return builder.build();
        }

        private <T> T evaluate(Object value, DataType expected) {
            try (ExpressionManagerSession session = A2AProtocolSerializer.this.expressionManager.openSession(this.bind(value));){
                Object object = session.evaluate(this.expression, expected).getValue();
                return (T)object;
            }
        }

        private String evaluateAsString(Object value, DataType expected) {
            CursorStreamProvider provider = (CursorStreamProvider)this.evaluate(value, expected);
            return IOUtils.toString((InputStream)((InputStream)provider.openCursor()));
        }

        private String evaluateAsStringWithBinding(String value, DataType expected, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            BindingContext.Builder builder = BindingContext.builder();
            bindingConfigurer.accept(value, builder);
            try (ExpressionManagerSession session = A2AProtocolSerializer.this.expressionManager.openSession(builder.build());){
                TypedValue result = session.evaluate(this.expression, expected);
                CursorStreamProvider provider = (CursorStreamProvider)result.getValue();
                String string = IOUtils.toString((InputStream)((InputStream)provider.openCursor()));
                return string;
            }
        }
    }
}

