/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.protocol;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.internal.error.exception.AgentCardDiscoveryException;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.util.IOUtils;

public class JsonRpcSerializer
implements Initialisable {
    private static final DataType JSON_STREAM_DATA_TYPE = DataType.builder().type(InputStream.class).mediaType(MediaType.JSON).build();
    private static final DataType JSON_RESPONSE_ERROR_DATA_TYPE = DataType.fromType(JsonRpcError.class);
    private static final DataType JSON_REQUEST_DATA_TYPE = DataType.fromType(JsonRpcRequest.class);
    private static final DataType AGENT_CARD_DATA_TYPE = DataType.fromType(AgentCard.class);
    public static final String PAYLOAD = "payload";
    private final AtomicLong idGenerator = new AtomicLong(0L);
    @Inject
    private ExpressionManager expressionManager;
    private DwConverter jsonRequestWriter;
    private DwConverter jsonResponseWriter;
    private DwConverter jsonErrorResponseWriter;
    private DwConverter responseResultReader;
    private DwConverter errorResponseReader;
    private DwConverter jsonWriter;
    private DwConverter jsonRpcRequestReader;
    private DwConverter agentCardReader;
    private DwConverter agentCardWriter;

    public InputStream writeJsonRequest(String method, Object params) {
        Map<String, Object> request = Map.of("id", Long.valueOf(this.idGenerator.incrementAndGet()).toString(), "method", method, "params", params);
        CursorStreamProvider provider = (CursorStreamProvider)this.jsonRequestWriter.evaluate(request, JSON_STREAM_DATA_TYPE);
        return (InputStream)provider.openCursor();
    }

    public String writeJsonResponse(Object id, InputStream result) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("id", id);
        response.put("result", result);
        return this.jsonResponseWriter.evaluateAsString(response, DataType.JSON_STRING);
    }

    public String writeJsonErrorResponse(Object id, int code, String message, Object data) {
        if (message == null || message.trim().isEmpty()) {
            throw new IllegalArgumentException("Error message must not be null or empty");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("id", id);
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("code", code);
        error.put("message", message);
        if (data != null) {
            error.put("data", data);
        }
        response.put("error", error);
        return this.jsonErrorResponseWriter.evaluateAsString(response, DataType.JSON_STRING);
    }

    public String writeJsonErrorResponse(Object id, int code, String message) {
        return this.writeJsonErrorResponse(id, code, message, null);
    }

    public String toJson(Object object) {
        return this.jsonWriter.evaluateAsString(object, DataType.JSON_STRING);
    }

    public String toAgentCardJson(AgentCard agentCard) throws AgentCardDiscoveryException.InvalidAgentCardException {
        if (agentCard == null) {
            throw new AgentCardDiscoveryException.InvalidAgentCardException("Agent card cannot be null", null);
        }
        return this.agentCardWriter.evaluateAsString(agentCard, DataType.JSON_STRING);
    }

    public JsonRpcRequest parseRpcRequest(InputStream inputStream) {
        return (JsonRpcRequest)this.jsonRpcRequestReader.evaluate(inputStream, JSON_REQUEST_DATA_TYPE);
    }

    public String getJsonResponseResult(String json) {
        return this.responseResultReader.evaluateAsString(json, DataType.JSON_STRING);
    }

    public JsonRpcError getJsonResponseError(String json) {
        return (JsonRpcError)this.errorResponseReader.evaluate(json, JSON_RESPONSE_ERROR_DATA_TYPE);
    }

    public AgentCard parseAgentCard(String json) {
        return (AgentCard)this.agentCardReader.evaluate(json, AGENT_CARD_DATA_TYPE);
    }

    public void initialise() {
        this.jsonWriter = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\npayload\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.jsonRequestWriter = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n  jsonrpc: \"2.0\",\n  id: payload.id,\n  method: payload.method,\n  params: read(payload.params, \"application/json\")\n}", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.responseResultReader = new DwConverter("output application/java\n---\npayload.result\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.JSON_STRING)));
        this.errorResponseReader = new DwConverter("output application/java\n---\nif (payload.error != null)\n  payload.error as Object {class: \"com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError\"}\nelse\n  null\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.JSON_STRING)));
        this.jsonRpcRequestReader = new DwConverter("output application/java\n---\n{\n  id: if (payload.id? == true) payload.id else \"MISSING_ID\",\n  method: payload.method,\n  params: write(payload.params, \"json\") as String\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest\"}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, JSON_STREAM_DATA_TYPE)));
        this.jsonResponseWriter = new DwConverter("output application/json\n---\n{\n  jsonrpc: \"2.0\",\n  id: payload.id,\n  result: read(payload.result, \"json\")\n}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.jsonErrorResponseWriter = new DwConverter("output application/json\n---\n{\n  jsonrpc: \"2.0\",\n  id: payload.id,\n  error: {\n    code: payload.error.code,\n    message: payload.error.message,\n    data: payload.error.data\n  }\n}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.agentCardReader = new DwConverter("output application/java\n---\n{\n  name: payload.name,\n  url: payload.url,\n  version: payload.version,\n  description: payload.description,\n  skills: payload.skills,\n  iconUrl: payload.iconUrl,\n  capabilities: if (payload.capabilities != null)\n    {\n      streaming: payload.capabilities.streaming default false,\n      pushNotifications: payload.capabilities.pushNotifications default false,\n      stateTransitionHistory: payload.capabilities.stateTransitionHistory default false,\n      extensions: if (payload.capabilities.extensions != null and payload.capabilities.extensions is Array)\n        payload.capabilities.extensions map (ext) ->\n          {\n            uri: ext.uri,\n            description: ext.description,\n            required: ext.required default false,\n            params: ext.params\n          } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.AgentExtension\"}\n      else\n        payload.capabilities.extensions\n    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.AgentCapabilities\"}\n  else\n    null,\n  provider: payload.provider,\n  documentationUrl: payload.documentationUrl,\n  defaultInputModes: payload.defaultInputModes,\n  defaultOutputModes: payload.defaultOutputModes,\n  supportsAuthenticatedExtendedCard: payload.supportsAuthenticatedExtendedCard default false,\n  security: if (payload.security != null and payload.security is Array)\n    payload.security flatMap (item) ->\n      item mapObject (value, key) ->\n        {\n          securitySchemeName: key,\n          scopes: value\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.SecurityRequirement\"}\n  else\n    payload.security,\n  securitySchemes: if (payload.securitySchemes != null and payload.securitySchemes is Object)\n    (payload.securitySchemes pluck (value, key) ->\n      if (value.\"type\" == \"http\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          schemeValue: value.scheme,\n          bearerFormat: value.bearerFormat\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.HttpSecurityScheme\"}\n      else if (value.\"type\" == \"apiKey\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          name: value.name,\n          inValue: value.\"in\"\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.ApiKeySecurityScheme\"}\n      else if (value.\"type\" == \"oauth2\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          flows: if (value.flows != null)\n            {\n              implicit: if (value.flows.implicit != null)\n                {\n                  authorizationUrl: value.flows.implicit.authorizationUrl,\n                  refreshUrl: value.flows.implicit.refreshUrl,\n                  oauth2Scopes: if (value.flows.implicit.scopes != null and value.flows.implicit.scopes is Object)\n                    (value.flows.implicit.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.ImplicitOauth2Flows\"}\n              else\n                null,\n              password: if (value.flows.password != null)\n                {\n                  tokenUrl: value.flows.password.tokenUrl,\n                  refreshUrl: value.flows.password.refreshUrl,\n                  oauth2Scopes: if (value.flows.password.scopes != null and value.flows.password.scopes is Object)\n                    (value.flows.password.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.PasswordOauth2Flows\"}\n              else\n                null,\n              clientCredentials: if (value.flows.clientCredentials != null)\n                {\n                  tokenUrl: value.flows.clientCredentials.tokenUrl,\n                  refreshUrl: value.flows.clientCredentials.refreshUrl,\n                  oauth2Scopes: if (value.flows.clientCredentials.scopes != null and value.flows.clientCredentials.scopes is Object)\n                    (value.flows.clientCredentials.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.ClientCredentialsOauth2Flows\"}\n              else\n                null,\n              authorizationCode: if (value.flows.authorizationCode != null)\n                {\n                  authorizationUrl: value.flows.authorizationCode.authorizationUrl,\n                  tokenUrl: value.flows.authorizationCode.tokenUrl,\n                  refreshUrl: value.flows.authorizationCode.refreshUrl,\n                  oauth2Scopes: if (value.flows.authorizationCode.scopes != null and value.flows.authorizationCode.scopes is Object)\n                    (value.flows.authorizationCode.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.AuthorizationCodeOauth2Flows\"}\n              else\n                null\n            } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Flows\"}\n          else\n            null\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2SecurityScheme\"}\n      else if (value.\"type\" == \"openIdConnect\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          openIdConnectUrl: value.openIdConnectUrl\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.OpenIdConnectSecurityScheme\"}\n      else\n        // Skip unsupported security scheme types\n        null\n      ) filter (item) -> item != null\n  else\n    payload.securitySchemes\n} as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.AgentCard\"}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.JSON_STRING)));
        this.agentCardWriter = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n  name: payload.name,\n  url: payload.url,\n  version: payload.version,\n  description: payload.description,\n  skills: payload.skills,\n  iconUrl: payload.iconUrl,\n  capabilities: if (payload.capabilities != null)\n    {\n      streaming: payload.capabilities.streaming,\n      pushNotifications: payload.capabilities.pushNotifications,\n      stateTransitionHistory: payload.capabilities.stateTransitionHistory,\n      extensions: if (payload.capabilities.extensions != null and payload.capabilities.extensions is Array)\n        payload.capabilities.extensions map (ext) ->\n          {\n            uri: ext.uri,\n            description: ext.description,\n            required: ext.required,\n            params: ext.params\n          }\n      else\n        payload.capabilities.extensions\n    }\n  else\n    null,\n  provider: payload.provider,\n  documentationUrl: payload.documentationUrl,\n  defaultInputModes: payload.defaultInputModes,\n  defaultOutputModes: payload.defaultOutputModes,\n  supportsAuthenticatedExtendedCard: payload.supportsAuthenticatedExtendedCard,\n  security: if (payload.security != null and payload.security is Array)\n    payload.security map (item) ->\n      { (item.securitySchemeName): item.scopes }\n  else\n    payload.security,\n  securitySchemes: if (payload.securitySchemes != null and payload.securitySchemes is Array)\n    (payload.securitySchemes map (item) ->\n      {\n        (item.securitySchemeName): if (item.\"type\" == \"http\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            scheme: item.schemeValue,\n            bearerFormat: item.bearerFormat\n          }\n        else if (item.\"type\" == \"apiKey\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            name: item.name,\n            \"in\": item.inValue\n          }\n        else if (item.\"type\" == \"oauth2\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            flows: if (item.flows != null)\n              {\n                implicit: if (item.flows.implicit != null)\n                  {\n                    authorizationUrl: item.flows.implicit.authorizationUrl,\n                    refreshUrl: item.flows.implicit.refreshUrl,\n                    scopes: if (item.flows.implicit.oauth2Scopes != null and item.flows.implicit.oauth2Scopes is Array)\n                      (item.flows.implicit.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.implicit.oauth2Scopes\n                  }\n                else\n                  null,\n                password: if (item.flows.password != null)\n                  {\n                    tokenUrl: item.flows.password.tokenUrl,\n                    refreshUrl: item.flows.password.refreshUrl,\n                    scopes: if (item.flows.password.oauth2Scopes != null and item.flows.password.oauth2Scopes is Array)\n                      (item.flows.password.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.password.oauth2Scopes\n                  }\n                else\n                  null,\n                clientCredentials: if (item.flows.clientCredentials != null)\n                  {\n                    tokenUrl: item.flows.clientCredentials.tokenUrl,\n                    refreshUrl: item.flows.clientCredentials.refreshUrl,\n                    scopes: if (item.flows.clientCredentials.oauth2Scopes != null and item.flows.clientCredentials.oauth2Scopes is Array)\n                      (item.flows.clientCredentials.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.clientCredentials.oauth2Scopes\n                  }\n                else\n                  null,\n                authorizationCode: if (item.flows.authorizationCode != null)\n                  {\n                    authorizationUrl: item.flows.authorizationCode.authorizationUrl,\n                    tokenUrl: item.flows.authorizationCode.tokenUrl,\n                    refreshUrl: item.flows.authorizationCode.refreshUrl,\n                    scopes: if (item.flows.authorizationCode.oauth2Scopes != null and item.flows.authorizationCode.oauth2Scopes is Array)\n                      (item.flows.authorizationCode.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.authorizationCode.oauth2Scopes\n                  }\n                else\n                  null\n              }\n            else\n              null\n          }\n        else if (item.\"type\" == \"openIdConnect\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            openIdConnectUrl: item.openIdConnectUrl\n          }\n        else\n          item\n      }) reduce (acc, item) -> acc ++ item\n  else\n    payload.securitySchemes\n}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
    }

    private class DwConverter {
        private final CompiledExpression expression;
        private final BiConsumer<Object, BindingContext.Builder> bindingConfigurer;

        private DwConverter(String expression, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this(expression, null, bindingConfigurer);
        }

        private DwConverter(String expression, Object defaultBindingValue, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this.bindingConfigurer = bindingConfigurer;
            this.expression = JsonRpcSerializer.this.expressionManager.compile(expression, this.bind(defaultBindingValue));
        }

        private BindingContext bind(Object value) {
            BindingContext.Builder builder = BindingContext.builder();
            this.bindingConfigurer.accept(value, builder);
            return builder.build();
        }

        private <T> T evaluate(Object value, DataType expected) {
            try (ExpressionManagerSession session = JsonRpcSerializer.this.expressionManager.openSession(this.bind(value));){
                Object object = session.evaluate(this.expression, expected).getValue();
                return (T)object;
            }
        }

        private String evaluateAsString(Object value, DataType expected) {
            CursorStreamProvider provider = (CursorStreamProvider)this.evaluate(value, expected);
            return IOUtils.toString((InputStream)((InputStream)provider.openCursor()));
        }
    }
}

