/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.history;

import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistory;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistoryItem;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskHistory
implements TaskHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskHistory.class);
    private final ObjectStore<TaskHistoryItem> historyObjectStore;
    private final LockFactory lockFactory;
    private final String ownerConfigName;

    public DefaultTaskHistory(ObjectStore<TaskHistoryItem> historyObjectStore, LockFactory lockFactory, String ownerConfigName) {
        this.historyObjectStore = historyObjectStore;
        this.lockFactory = lockFactory;
        this.ownerConfigName = ownerConfigName;
    }

    @Override
    public void upsert(String taskId, TaskHistoryItem item) throws ObjectStoreException {
        this.withLock(taskId, () -> {
            if (this.historyObjectStore.contains(taskId)) {
                this.historyObjectStore.remove(taskId);
            }
            this.historyObjectStore.store(taskId, (Serializable)item);
            return null;
        });
    }

    @Override
    public Optional<TaskHistoryItem> get(String taskId) throws ObjectNotFoundException, ObjectStoreException {
        return (Optional)this.withLock(taskId, () -> {
            if (this.historyObjectStore.contains(taskId)) {
                return Optional.of((TaskHistoryItem)this.historyObjectStore.retrieve(taskId));
            }
            return Optional.empty();
        });
    }

    @Override
    public void remove(String taskId) throws ObjectStoreException {
        this.withLock(taskId, () -> {
            try {
                this.historyObjectStore.remove(taskId);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.debug("Could not remove task with id {} because it doesn't exist. Resuming...", (Object)taskId);
            }
            return null;
        });
    }

    private <T> T withLock(String taskId, CheckedSupplier<T> supplier) throws ObjectStoreException {
        Lock lock = this.lockFactory.createLock(this.getLockKey(taskId));
        lock.lock();
        try {
            Object object = supplier.get();
            return (T)object;
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof ObjectStoreException) {
                ObjectStoreException e = (ObjectStoreException)cause;
                throw e;
            }
            throw new ObjectStoreException(cause);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.historyObjectStore.close();
        }
        catch (Exception e) {
            LOGGER.error("Error closing task store for config {}", (Object)this.ownerConfigName, (Object)e);
        }
    }

    private String getLockKey(String taskId) {
        return "_a2a-taskRepository-" + this.ownerConfigName + "-" + taskId;
    }
}

