/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.history;

import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistory;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskStoreService;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.JsonUtils;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskStoreServiceImpl
implements TaskStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTaskStoreServiceImpl.class);
    public static final String TASK_FIELD = "task";
    public static final String HISTORY_FIELD = "history";
    public static final String HISTORY_FIELD_LENGTH = "historyLength";
    private final TaskHistory taskHistory;

    public DefaultTaskStoreServiceImpl(TaskHistory taskHistory) {
        this.taskHistory = taskHistory;
    }

    @Override
    public void updateHistory(String taskId, String historyObj) throws ObjectStoreException {
        Optional<TaskHistoryItem> historyItem = this.taskHistory.get(taskId);
        JsonArrayBuilder itemsBuilder = Json.createArrayBuilder();
        JsonObjectBuilder newTaskBuilder = Json.createObjectBuilder();
        if (historyItem.isPresent()) {
            JsonObject existingTaskDetails = JsonUtils.parseJsonObject(historyItem.get().getTaskJson());
            if (existingTaskDetails.containsKey((Object)HISTORY_FIELD)) {
                JsonArray existingItems = existingTaskDetails.getJsonArray(HISTORY_FIELD);
                existingItems.forEach(arg_0 -> ((JsonArrayBuilder)itemsBuilder).add(arg_0));
            }
            if (existingTaskDetails.containsKey((Object)TASK_FIELD)) {
                newTaskBuilder.add(TASK_FIELD, (JsonValue)existingTaskDetails.getJsonObject(TASK_FIELD));
            }
        }
        itemsBuilder.add((JsonValue)JsonUtils.parseJsonObject(historyObj));
        JsonArray items = itemsBuilder.build();
        JsonObject newTaskDetails = newTaskBuilder.add(HISTORY_FIELD_LENGTH, items.size()).add(HISTORY_FIELD, (JsonValue)items).build();
        String taskJson = JsonUtils.writeJsonObjectToString(newTaskDetails);
        TaskHistoryItem newHistoryItem = new TaskHistoryItem(taskJson);
        LOG.debug("Updating taskJson history for task id: {} to: {}", (Object)taskJson, (Object)taskId);
        this.taskHistory.upsert(taskId, newHistoryItem);
    }

    @Override
    public void updateTask(String taskId, String taskObj) throws ObjectStoreException {
        Optional<TaskHistoryItem> historyItem = this.taskHistory.get(taskId);
        JsonObjectBuilder newTaskBuilder = Json.createObjectBuilder();
        if (historyItem.isPresent()) {
            JsonObject existingTaskDetails = JsonUtils.parseJsonObject(historyItem.get().getTaskJson());
            if (existingTaskDetails.containsKey((Object)HISTORY_FIELD_LENGTH)) {
                newTaskBuilder.add(HISTORY_FIELD_LENGTH, existingTaskDetails.getInt(HISTORY_FIELD_LENGTH));
            }
            if (existingTaskDetails.containsKey((Object)HISTORY_FIELD)) {
                newTaskBuilder.add(HISTORY_FIELD, (JsonValue)existingTaskDetails.getJsonArray(HISTORY_FIELD));
            }
        } else {
            newTaskBuilder.add(HISTORY_FIELD_LENGTH, 0).add(HISTORY_FIELD, (JsonValue)Json.createArrayBuilder().build());
        }
        newTaskBuilder.add(TASK_FIELD, (JsonValue)JsonUtils.parseJsonObject(taskObj));
        JsonObject newTaskDetails = newTaskBuilder.build();
        String taskJson = JsonUtils.writeJsonObjectToString(newTaskDetails);
        TaskHistoryItem newHistoryItem = new TaskHistoryItem(taskJson);
        LOG.debug("Updating taskJson task for task id: {} to: {}", (Object)taskJson, (Object)taskId);
        this.taskHistory.upsert(taskId, newHistoryItem);
    }
}

