/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.TaskContext;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.TaskExecutor;
import com.mulesoft.connectors.a2a.internal.server.agent.request.TaskQueryParams;
import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import com.mulesoft.connectors.a2a.internal.util.certificate.HttpUtils;
import java.io.ByteArrayInputStream;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTaskExecutor
extends TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetTaskExecutor.class);
    private static final String INVALID_PARAMS_MESSAGE = "Invalid method parameters";
    private static final String TASK_NOT_FOUND_MESSAGE = "Task not found";
    private static final String INTERNAL_ERROR_MESSAGE = "Internal error";
    private final A2AProtocolSerializer messageSerializer;

    public GetTaskExecutor(TaskContext taskContext) {
        super(taskContext.getRequestContext(), taskContext.getResponseCallback(), taskContext.getRpcRequest(), taskContext.getSerializer(), taskContext.getTaskHistory(), taskContext.getTaskStoreService());
        this.messageSerializer = (A2AProtocolSerializer)taskContext.getMessageSerializer();
    }

    @Override
    public RpcRequestContext execute() {
        LOGGER.debug("Processing tasks/get request - requestId: {}", this.rpcRequest.getId());
        RpcRequestContext context = this.createRequestContext();
        JsonRpcResult result = this.messageSerializer.getTaskQueryParams(this.rpcRequest.getParams());
        String taskId = null;
        Integer historyLength = null;
        Object object = result.getResult();
        if (object instanceof TaskQueryParams) {
            TaskQueryParams taskQueryParams = (TaskQueryParams)object;
            taskId = taskQueryParams.getId();
            historyLength = taskQueryParams.getHistoryLength();
        }
        if (taskId == null || taskId.trim().isEmpty()) {
            this.handleInvalidParams(context);
        } else {
            try {
                this.processTaskRequest(context, taskId, historyLength);
            }
            catch (Exception e) {
                LOGGER.error("Failed to process task request - taskId: {}", (Object)taskId, (Object)e);
                this.handleInternalError(context);
            }
        }
        this.setupResponseHandler(context);
        return context;
    }

    private RpcRequestContext createRequestContext() {
        return new RpcRequestContext(this.rpcRequest, HttpUtils.buildRequestAttributes(this.httpRequestContext));
    }

    private void processTaskRequest(RpcRequestContext context, String taskId, int historyLength) {
        try {
            LOGGER.debug("Retrieving task from history - taskId: {}", (Object)taskId);
            this.taskHistory.get(taskId).ifPresentOrElse(item -> {
                LOGGER.debug("Task found in history - taskId: {}", (Object)taskId);
                this.handleTaskFound(context, (TaskHistoryItem)item, historyLength);
            }, () -> this.handleTaskNotFound(context));
        }
        catch (ObjectStoreException e) {
            LOGGER.error("ObjectStore operation failed while retrieving task - taskId: {}", (Object)taskId, (Object)e);
            this.handleInternalError(context);
        }
    }

    private void handleTaskFound(RpcRequestContext context, TaskHistoryItem taskHistoryItem, int historyLength) {
        try {
            String taskHistoryJson = taskHistoryItem.getTaskJson();
            String transformedResponse = this.messageSerializer.transformTaskHistoryResponse(taskHistoryJson, historyLength);
            RpcRequestContext.Response successResponse = this.createSuccessResponse(transformedResponse);
            context.getResponseFuture().complete(successResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to transform task history response", (Throwable)e);
            this.handleInternalError(context);
        }
    }

    private RpcRequestContext.Response createSuccessResponse(String transformedResponse) {
        return RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.OK.getStatusCode()).body(new ByteArrayInputStream(transformedResponse.getBytes())).build();
    }

    private void handleInvalidParams(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INVALID_PARAMS.getJsonRpcCode().get(), INVALID_PARAMS_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void handleTaskNotFound(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.TASK_NOT_FOUND.getJsonRpcCode().get(), TASK_NOT_FOUND_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void handleInternalError(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().get(), INTERNAL_ERROR_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void setupResponseHandler(RpcRequestContext context) {
        context.getResponseFuture().whenComplete((response, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Unexpected error in response future - requestId: {}", this.rpcRequest.getId(), throwable);
                ServerAgentUtils.sendExceptionalHttpResponse(this.rpcRequest, throwable, this.responseCallback, this.serializer);
            } else {
                this.sendSuccessfulResponse((RpcRequestContext.Response)response);
            }
        });
    }

    private void sendSuccessfulResponse(RpcRequestContext.Response response) {
        try {
            String responseBody = ServerAgentUtils.createResponseBody(this.rpcRequest, response, this.serializer);
            ServerAgentUtils.sendHttpResponse(response.getStatusCode(), responseBody, response.getHeaders(), this.responseCallback);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send HTTP response - requestId: {}", this.rpcRequest.getId(), (Object)e);
            ServerAgentUtils.sendExceptionalHttpResponse(this.rpcRequest, e, this.responseCallback, this.serializer);
        }
    }
}

