/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.server.agent.TaskContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.GetTaskExecutor;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.SendMessageExecutor;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.TaskExecutor;
import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskMethod {
    MESSAGE_SEND("message/send", true){

        @Override
        public TaskExecutor fetchTask(TaskContext taskContext) {
            return new SendMessageExecutor(taskContext, true);
        }
    }
    ,
    TASKS_SEND("tasks/send", true){

        @Override
        public TaskExecutor fetchTask(TaskContext taskContext) {
            return new SendMessageExecutor(taskContext, false);
        }
    }
    ,
    TASKS_GET("tasks/get", true){

        @Override
        public TaskExecutor fetchTask(TaskContext taskContext) {
            return new GetTaskExecutor(taskContext);
        }
    };

    private final String name;
    private final boolean isSupported;

    public abstract TaskExecutor fetchTask(TaskContext var1);

    private TaskMethod(String name, boolean isSupported) {
        this.name = name;
        this.isSupported = isSupported;
    }

    public static TaskMethod fromName(String methodName) {
        return Arrays.stream(TaskMethod.values()).filter(method -> methodName.equals(method.name)).findFirst().orElse(null);
    }

    public static boolean validate(String methodName) {
        if (methodName == null || methodName.isEmpty()) {
            return false;
        }
        return Arrays.stream(TaskMethod.values()).anyMatch(method -> method.name.equals(methodName) && method.isSupported);
    }
}

