/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.utils;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JsonObject parseJsonObject(String jsonString) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    public static JsonArray parseJsonArray(String jsonString) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonArray jsonArray = reader.readArray();
            return jsonArray;
        }
    }

    public static String writeJsonArrayToString(JsonArray jsonArray) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter writer = Json.createWriter((Writer)stringWriter);){
            writer.writeArray(jsonArray);
        }
        return stringWriter.toString();
    }

    public static String writeJsonObjectToString(JsonObject jsonObject) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter writer = Json.createWriter((Writer)stringWriter);){
            writer.writeObject(jsonObject);
        }
        return stringWriter.toString();
    }
}

