/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.connection.http;

import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.server.agent.ServerAgent;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.sdk.api.annotation.semantics.connectivity.UrlPath;

public class HttpServerConnectionProvider
implements CachedConnectionProvider<ServerAgent>,
NoConnectivityTest {
    @Inject
    HttpService httpService;
    @Inject
    JsonRpcSerializer jsonRpcSerializer;
    @Inject
    A2AProtocolSerializer messageSerializer;
    @Inject
    LockFactory lockFactory;
    @Inject
    ObjectStoreManager objectStoreManager;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ConfigReference(name="LISTENER_CONFIG", namespace="HTTP")
    @Summary(value="Reference to the <http:listener-config> used to expose the inbound endpoint")
    String listenerConfig;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @UrlPath
    String agentPath;

    public ServerAgent connect() {
        try {
            return new ServerAgent(this.httpService.getServerFactory().lookup(this.listenerConfig), this.agentPath, this.jsonRpcSerializer, this.messageSerializer, this.lockFactory, this.objectStoreManager);
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find <http:listener-config> named '%s'".formatted(this.listenerConfig), (Object[])new Object[]{e}));
        }
    }

    public void disconnect(ServerAgent server) {
        server.stop();
    }

    public ConnectionValidationResult validate(ServerAgent server) {
        return ConnectionValidationResult.success();
    }
}

