/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.tracing;

import com.mulesoft.connectors.a2a.internal.tracing.SpanCustomizer;
import java.net.URI;
import java.net.URISyntaxException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundSpanCustomizer
extends SpanCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboundSpanCustomizer.class);
    private static final String HTTP_TARGET = "http.target";
    private static final String NET_HOST_NAME = "net.host.name";
    private static final String NET_HOST_PORT = "net.host.port";
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_SCHEME = "http.scheme";
    private static final String HTTP_ROUTE = "http.route";
    private static final String SPAN_KIND_NAME = "SERVER";
    private String path;
    private String host;
    private Integer port;
    private String version;
    private String scheme;
    private MultiMap<String, String> headers;
    private String method;

    public InboundSpanCustomizer(DistributedTraceContextManager traceContextManager, String path, String host, Integer port, String version, String scheme, MultiMap<String, String> headers, String method) {
        super(traceContextManager);
        this.path = path;
        this.host = host;
        this.port = port;
        this.version = version;
        this.scheme = scheme;
        this.headers = headers != null ? headers : MultiMap.emptyMultiMap();
        this.method = method;
    }

    @Override
    public void customizeSpan() {
        super.customizeSpan();
        try {
            this.traceContextManager.setRemoteTraceContextMap(this.headers);
            this.traceContextManager.addCurrentSpanAttribute(HTTP_TARGET, this.path);
            this.traceContextManager.addCurrentSpanAttribute(NET_HOST_NAME, this.host);
            this.traceContextManager.addCurrentSpanAttribute(NET_HOST_PORT, String.valueOf(this.getURI().getPort()));
            this.traceContextManager.addCurrentSpanAttribute(HTTP_SCHEME, this.scheme);
            this.traceContextManager.addCurrentSpanAttribute(HTTP_ROUTE, this.path);
            String userAgent = (String)this.headers.get((Object)"User-Agent");
            if (userAgent != null) {
                this.traceContextManager.addCurrentSpanAttribute(HTTP_USER_AGENT, userAgent);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Error on setting listener span attributes.", e);
        }
    }

    @Override
    public String getProtocol() {
        return this.scheme.toUpperCase();
    }

    @Override
    public String getMethod() {
        return this.method.toUpperCase();
    }

    @Override
    public String getFlavor() {
        return this.resolveFlavor(this.version);
    }

    private String resolveFlavor(String version) {
        if (version == null) {
            return null;
        }
        return version.substring(version.indexOf("/") + 1);
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return new URI(this.scheme, null, this.host, this.port, this.path, null, null);
    }

    @Override
    protected String getSpanKind() {
        return SPAN_KIND_NAME;
    }
}

