/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.tracing;

import com.mulesoft.connectors.a2a.internal.tracing.OutboundSpanCustomizer;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;

public class TracingUtils {
    public static final String HTTP_STATUS_CODE = "http.status_code";
    public static final String SPAN_STATUS = "status.override";
    public static final String ERROR_STATUS = "ERROR";
    public static final String UNSET_STATUS = "UNSET";

    private TracingUtils() {
    }

    public static void traceResponseStatusCode(DistributedTraceContextManager traceContextManager, int statusCode, Logger logger) {
        try {
            traceContextManager.addCurrentSpanAttribute(HTTP_STATUS_CODE, String.valueOf(statusCode));
            traceContextManager.addCurrentSpanAttribute(SPAN_STATUS, statusCode >= 400 ? ERROR_STATUS : UNSET_STATUS);
        }
        catch (Throwable e) {
            logger.warn("An exception on processing the span http status code", e);
        }
    }

    public static void traceOutboundRequest(DistributedTraceContextManager traceContextManager, HttpRequest request) {
        if (traceContextManager != null) {
            new OutboundSpanCustomizer(traceContextManager, request).customizeSpan();
        }
    }

    public static HttpRequestBuilder propagateTraceContext(HttpRequestBuilder builder, DistributedTraceContextManager traceContextManager) {
        if (traceContextManager != null) {
            traceContextManager.getRemoteTraceContextMap().forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        }
        return builder;
    }
}

