/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card;

import java.util.List;
import java.util.Objects;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.meta.ExpressionSupport;

public class AgentAuthentication {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Authentication Schemes")
    @Summary(value="The list of authentication schemes supported by this agent (e.g., 'bearer', 'basic', etc.)")
    private List<String> schemes;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Credentials")
    @Summary(value="Optional credentials information needed for authentication")
    private String credentials;

    public AgentAuthentication copy() {
        AgentAuthentication copy = new AgentAuthentication();
        copy.schemes = this.schemes;
        copy.credentials = this.credentials;
        return copy;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<String> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException("Authentication schemes cannot be null");
        }
        this.schemes = schemes;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object object) {
        if (object instanceof AgentAuthentication) {
            AgentAuthentication that = (AgentAuthentication)object;
            return Objects.equals(this.schemes, that.schemes) && Objects.equals(this.credentials, that.credentials);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.schemes, this.credentials);
    }
}

