/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card;

import com.mulesoft.connectors.a2a.api.model.card.AgentExtension;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AgentCapabilities {
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Streaming Support")
    @Summary(value="Indicates whether the agent supports streaming communication")
    private boolean streaming = false;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Push Notifications Support")
    @Summary(value="Indicates whether the agent supports push notifications")
    private boolean pushNotifications = false;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="State Transition History Support")
    @Summary(value="Indicates whether the agent tracks and provides state transition history")
    private boolean stateTransitionHistory = false;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Extensions")
    @Summary(value="The list of extensions supported by this agent")
    private List<AgentExtension> extensions;

    public AgentCapabilities copy() {
        AgentCapabilities copy = new AgentCapabilities();
        copy.streaming = this.streaming;
        copy.pushNotifications = this.pushNotifications;
        copy.stateTransitionHistory = this.stateTransitionHistory;
        if (this.extensions != null) {
            copy.extensions = this.extensions.stream().map(AgentExtension::copy).toList();
        }
        return copy;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isPushNotifications() {
        return this.pushNotifications;
    }

    public void setPushNotifications(boolean pushNotifications) {
        this.pushNotifications = pushNotifications;
    }

    public boolean isStateTransitionHistory() {
        return this.stateTransitionHistory;
    }

    public void setStateTransitionHistory(boolean stateTransitionHistory) {
        this.stateTransitionHistory = stateTransitionHistory;
    }

    public List<AgentExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<AgentExtension> extensions) {
        this.extensions = extensions;
    }

    public boolean equals(Object object) {
        if (object instanceof AgentCapabilities) {
            AgentCapabilities that = (AgentCapabilities)object;
            return this.streaming == that.streaming && this.pushNotifications == that.pushNotifications && this.stateTransitionHistory == that.stateTransitionHistory && Objects.equals(this.extensions, that.extensions);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.streaming, this.pushNotifications, this.stateTransitionHistory, this.extensions);
    }
}

