/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card;

import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;

public class AgentProvider {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Organization")
    @Summary(value="The name of the organization that provides this agent")
    private String organization;
    @Parameter
    @Url
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Provider URL")
    @Summary(value="The URL to the provider's website or contact information")
    private String url;

    public AgentProvider copy() {
        AgentProvider copy = new AgentProvider();
        copy.organization = this.organization;
        copy.url = this.url;
        return copy;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        if (organization == null || organization.trim().isEmpty()) {
            throw new IllegalArgumentException("Provider organization is required and cannot be null or empty");
        }
        this.organization = organization;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object object) {
        if (object instanceof AgentProvider) {
            AgentProvider that = (AgentProvider)object;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.url, that.url);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.organization, this.url);
    }
}

