/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.mulesoft.connectors.a2a.api.model.card.SecurityScheme;
import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Flows;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="Oauth2 Security Scheme")
public class Oauth2SecurityScheme
extends SecurityScheme {
    private final String type = "oauth2";
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Flows")
    @Summary(value="Configuration information for the Oauth2 flow types supported")
    private Oauth2Flows flows;

    @Override
    public Oauth2SecurityScheme copy() {
        Oauth2SecurityScheme copy = new Oauth2SecurityScheme();
        copy.setSecuritySchemeName(this.getSecuritySchemeName());
        copy.setDescription(this.getDescription());
        copy.flows = this.flows != null ? this.flows.copy() : null;
        return copy;
    }

    @Override
    public String getType() {
        return "oauth2";
    }

    public Oauth2Flows getFlows() {
        return this.flows;
    }

    public void setFlows(Oauth2Flows flows) {
        this.flows = flows;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Oauth2SecurityScheme) {
            Oauth2SecurityScheme oauth2SecurityScheme = (Oauth2SecurityScheme)object;
            return super.equals(object) && Objects.equals(this.flows, oauth2SecurityScheme.flows);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.flows);
    }
}

