/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.transport;

import java.io.Serializable;
import java.util.Objects;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ResponseAttributes
implements Serializable {
    @Parameter
    @DisplayName(value="Status Code")
    @Summary(value="The HTTP status code of the response")
    private int statusCode;
    @Parameter
    @DisplayName(value="Headers")
    @Summary(value="The HTTP headers to be included in the response")
    private MultiMap<String, String> headers;
    @Parameter
    @Optional
    @DisplayName(value="Reason Phrase")
    @Summary(value="The reason phrase associated with the HTTP status code")
    private String reasonPhrase;

    public ResponseAttributes(int statusCode, MultiMap<String, String> headers, String reasonPhrase) {
        this.statusCode = statusCode;
        this.headers = headers != null ? new MultiMap(headers) : MultiMap.emptyMultiMap();
        this.reasonPhrase = reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResponseAttributes) {
            ResponseAttributes that = (ResponseAttributes)obj;
            return this.statusCode == that.statusCode && Objects.equals(this.headers, that.headers) && Objects.equals(this.reasonPhrase, that.reasonPhrase);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.headers, this.reasonPhrase);
    }
}

