/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.client.operation;

import com.mulesoft.connectors.a2a.api.model.transport.ResponseAttributes;
import com.mulesoft.connectors.a2a.internal.client.connection.A2AClient;
import com.mulesoft.connectors.a2a.internal.error.AgentCardErrorTypeProvider;
import com.mulesoft.connectors.a2a.internal.error.BasicOperationErrorTypeProvider;
import com.mulesoft.connectors.a2a.internal.error.JsonRpcErrorTypeProvider;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.InputJsonType;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

@Throws(value={BasicOperationErrorTypeProvider.class, JsonRpcErrorTypeProvider.class})
public class ClientOperations {
    @Throws(value={AgentCardErrorTypeProvider.class, BasicOperationErrorTypeProvider.class})
    @OutputJsonType(schema="schemas/AgentCard.json")
    public void getCard(@Connection A2AClient client, @Optional(defaultValue="false") @DisplayName(value="Use Extended Card") @Summary(value="When true, fetches the authenticated extended agent card instead of the normal agent card") boolean useExtendedCard, DistributedTraceContextManager traceContextManager, CompletionCallback<String, ResponseAttributes> completionCallback) {
        this.map(client.getCard(useExtendedCard, traceContextManager), completionCallback);
    }

    @OutputJsonType(schema="schemas/Task.json")
    public void sendTask(@Connection A2AClient client, @Content @InputJsonType(schema="schemas/MessageSendParams.json") InputStream task, DistributedTraceContextManager traceContextManager, CompletionCallback<String, ResponseAttributes> completionCallback) {
        this.map(client.sendTask(task, traceContextManager), completionCallback);
    }

    @OutputJsonType(schema="schemas/TaskOrMessage.json")
    public void sendMessage(@Connection A2AClient client, @Content @InputJsonType(schema="schemas/MessageSendParams.json") InputStream message, DistributedTraceContextManager traceContextManager, CompletionCallback<String, ResponseAttributes> completionCallback) {
        this.map(client.sendMessage(message, traceContextManager), completionCallback);
    }

    @OutputJsonType(schema="schemas/Task.json")
    public void getTask(@Connection A2AClient client, @Content @InputJsonType(schema="schemas/TaskQueryParams.json") InputStream taskQuery, DistributedTraceContextManager traceContextManager, CompletionCallback<String, ResponseAttributes> completionCallback) {
        this.map(client.getTask(taskQuery, traceContextManager), completionCallback);
    }

    @OutputJsonType(schema="schemas/Task.json")
    public void cancelTask(@Connection A2AClient client, @Content @InputJsonType(schema="schemas/TaskIdParams.json") InputStream taskId, DistributedTraceContextManager traceContextManager, CompletionCallback<String, ResponseAttributes> completionCallback) {
        this.map(client.cancelTask(taskId, traceContextManager), completionCallback);
    }

    private void map(CompletableFuture<Result<String, ResponseAttributes>> future, CompletionCallback<String, ResponseAttributes> completionCallback) {
        future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                completionCallback.error(throwable);
            } else {
                completionCallback.success(result);
            }
        });
    }
}

