/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.ServerConfig;
import com.mulesoft.connectors.a2a.internal.server.TaskHistoryParameterGroup;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.TaskContext;
import com.mulesoft.connectors.a2a.internal.server.agent.history.DefaultTaskHistory;
import com.mulesoft.connectors.a2a.internal.server.agent.history.DefaultTaskStoreServiceImpl;
import com.mulesoft.connectors.a2a.internal.server.agent.history.NullTaskHistory;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistory;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskStoreService;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.TaskExecutor;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.TaskMethod;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import com.mulesoft.connectors.a2a.internal.tracing.InboundSpanCustomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAgent.class);
    private final HttpServer httpServer;
    private final String path;
    private final JsonRpcSerializer serializer;
    private final A2AProtocolSerializer messageSerializer;
    private final LockFactory lockFactory;
    private final ObjectStoreManager objectStoreManager;
    private final List<RequestHandlerManager> requestHandlers = new ArrayList<RequestHandlerManager>();
    private AgentCard card;
    private ComponentLocation listenerComponentLocation;
    private TaskHistory taskHistory;
    private Consumer<RpcRequestContext> onRequest;
    private TaskStoreService taskStoreService;
    private boolean taskHistoryEnabled;

    public ServerAgent(HttpServer httpServer, String path, JsonRpcSerializer serializer, A2AProtocolSerializer messageSerializer, LockFactory lockFactory, ObjectStoreManager objectStoreManager) {
        this.httpServer = httpServer;
        this.path = path.endsWith("/") ? path : path + "/";
        this.serializer = serializer;
        this.lockFactory = lockFactory;
        this.objectStoreManager = objectStoreManager;
        this.messageSerializer = messageSerializer;
    }

    public void initServer(ServerConfig config, ComponentLocation listenerComponentLocation, Consumer<RpcRequestContext> onRequest) {
        if (this.listenerComponentLocation != null) {
            throw new IllegalStateException("A task listener already exists for config %s. Only one can be defined per <a2a:server-config> element".formatted(config.getConfigName()));
        }
        this.listenerComponentLocation = listenerComponentLocation;
        this.card = config.getCard().copy();
        this.taskHistory = this.createTaskHistory(config);
        this.taskStoreService = new DefaultTaskStoreServiceImpl(this.taskHistory);
        try {
            this.requestHandlers.add(this.createCardRequestHandler());
            this.requestHandlers.add(this.createTaskRequestHandler());
        }
        catch (Exception e) {
            this.stop();
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Failed to create request handlers for config " + config.getConfigName())), (Throwable)e);
        }
        this.onRequest = onRequest;
    }

    public void addTracingData(RpcRequestContext context, DistributedTraceContextManager traceManager) {
        ServerAddress serverAddress = this.httpServer.getServerAddress();
        new InboundSpanCustomizer(traceManager, this.path, serverAddress.getIp(), serverAddress.getPort(), this.httpServer.getProtocol().toString(), this.httpServer.getProtocol().getScheme(), context.getRequestAttributes().getHeaders(), "POST").customizeSpan();
    }

    private TaskHistory createTaskHistory(ServerConfig serverConfig) {
        TaskHistoryParameterGroup historyConfig = serverConfig.getTaskHistory();
        this.taskHistoryEnabled = historyConfig.isTaskHistoryEnabled();
        if (!this.taskHistoryEnabled) {
            return NullTaskHistory.INSTANCE;
        }
        ObjectStore os = historyConfig.getTaskHistoryObjectStore();
        if (os == null) {
            try {
                os = this.objectStoreManager.getOrCreateObjectStore("_a2a-taskRepository-" + serverConfig.getConfigName(), ObjectStoreSettings.builder().maxEntries(historyConfig.getDefaultMaxHistoryLength()).persistent(false).build());
                os.open();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Failed to create default task history store for config " + serverConfig.getConfigName())), (Throwable)e);
            }
        }
        return new DefaultTaskHistory((ObjectStore<TaskHistoryItem>)os, this.lockFactory, serverConfig.getConfigName());
    }

    private RequestHandlerManager createTaskRequestHandler() {
        RequestHandlerManager handler = this.httpServer.addRequestHandler(List.of("POST"), this.path, (requestContext, responseCallback) -> {
            JsonRpcRequest jsonRequest;
            HttpRequest httpRequest = requestContext.getRequest();
            try {
                jsonRequest = this.serializer.parseRpcRequest(httpRequest.getEntity().getContent());
                if (!TaskMethod.validate(jsonRequest.getMethod())) {
                    ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.METHOD_NOT_FOUND, "Method not found or unsupported - " + jsonRequest.getMethod(), jsonRequest, responseCallback, this.serializer);
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error parsing request", (Throwable)e);
                JsonRpcRequest rpcRequest = new JsonRpcRequest();
                rpcRequest.id = null;
                ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.PARSE_ERROR, "Invalid JSON payload", rpcRequest, responseCallback, this.serializer);
                return;
            }
            try {
                jsonRequest.validate();
            }
            catch (IllegalArgumentException e) {
                ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.INVALID_REQUEST, e.getMessage(), jsonRequest, responseCallback, this.serializer);
                return;
            }
            TaskContext taskContext = TaskContext.builder().requestContext(requestContext).responseCallback(responseCallback).taskStoreService(this.taskStoreService).taskHistory(this.taskHistory).serializer(this.serializer).messageSerializer(this.messageSerializer).taskHistoryEnabled(this.taskHistoryEnabled).rpcRequest(jsonRequest).build();
            TaskExecutor taskExecutor = TaskMethod.fromName(jsonRequest.getMethod()).fetchTask(taskContext);
            RpcRequestContext context = taskExecutor.execute();
            this.onRequest.accept(context);
        });
        handler.start();
        return handler;
    }

    private RequestHandlerManager createCardRequestHandler() {
        try {
            String jsonCard = this.serializer.toAgentCardJson(this.card);
            RequestHandlerManager handler = this.httpServer.addRequestHandler(List.of("GET"), this.path + ".well-known/agent.json", (requestContext, responseCallback) -> ServerAgentUtils.sendHttpResponse(200, jsonCard, responseCallback));
            handler.start();
            return handler;
        }
        catch (Exception e) {
            LOGGER.error("Error creating card request handler", (Throwable)e);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to create card request handler"), (Throwable)e);
        }
    }

    public void stop() {
        this.requestHandlers.forEach(handler -> {
            try {
                handler.stop();
                handler.dispose();
            }
            catch (Exception e) {
                LOGGER.error("Error stopping request handler", (Throwable)e);
            }
        });
        this.requestHandlers.clear();
        this.listenerComponentLocation = null;
        this.taskHistory.close();
        this.onRequest = null;
    }

    public AgentCard getCard() {
        return this.card;
    }

    public String getPath() {
        return this.path;
    }
}

