/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent;

import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskHistory;
import com.mulesoft.connectors.a2a.internal.server.agent.history.TaskStoreService;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;

public class TaskContext {
    private final HttpRequestContext requestContext;
    private final HttpResponseReadyCallback responseCallback;
    private final JsonRpcRequest rpcRequest;
    private final JsonRpcSerializer serializer;
    private final TaskHistory taskHistory;
    private final TaskStoreService taskStoreService;
    private final Initialisable messageSerializer;
    private final boolean taskHistoryEnabled;

    private TaskContext(Builder builder) {
        this.requestContext = builder.requestContext;
        this.responseCallback = builder.responseCallback;
        this.rpcRequest = builder.rpcRequest;
        this.serializer = builder.serializer;
        this.taskHistory = builder.taskHistory;
        this.messageSerializer = builder.messageSerializer;
        this.taskStoreService = builder.taskStoreService;
        this.taskHistoryEnabled = builder.taskHistoryEnabled;
    }

    public HttpRequestContext getRequestContext() {
        return this.requestContext;
    }

    public HttpResponseReadyCallback getResponseCallback() {
        return this.responseCallback;
    }

    public JsonRpcRequest getRpcRequest() {
        return this.rpcRequest;
    }

    public TaskStoreService getTaskStoreService() {
        return this.taskStoreService;
    }

    public JsonRpcSerializer getSerializer() {
        return this.serializer;
    }

    public TaskHistory getTaskHistory() {
        return this.taskHistory;
    }

    public boolean isTaskHistoryEnabled() {
        return this.taskHistoryEnabled;
    }

    public Initialisable getMessageSerializer() {
        return this.messageSerializer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpRequestContext requestContext;
        private HttpResponseReadyCallback responseCallback;
        private JsonRpcRequest rpcRequest;
        private JsonRpcSerializer serializer;
        private TaskHistory taskHistory;
        private Initialisable messageSerializer;
        private TaskStoreService taskStoreService;
        private boolean taskHistoryEnabled;

        private Builder() {
        }

        public Builder requestContext(HttpRequestContext requestContext) {
            this.requestContext = requestContext;
            return this;
        }

        public Builder taskStoreService(TaskStoreService taskStoreService) {
            this.taskStoreService = taskStoreService;
            return this;
        }

        public Builder responseCallback(HttpResponseReadyCallback responseCallback) {
            this.responseCallback = responseCallback;
            return this;
        }

        public Builder rpcRequest(JsonRpcRequest rpcRequest) {
            this.rpcRequest = rpcRequest;
            return this;
        }

        public Builder serializer(JsonRpcSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder taskHistory(TaskHistory taskHistory) {
            this.taskHistory = taskHistory;
            return this;
        }

        public Builder taskHistoryEnabled(boolean taskHistoryEnabled) {
            this.taskHistoryEnabled = taskHistoryEnabled;
            return this;
        }

        public Builder messageSerializer(Initialisable messageSerializer) {
            this.messageSerializer = messageSerializer;
            return this;
        }

        public TaskContext build() {
            return new TaskContext(this);
        }
    }
}

