/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.TaskContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.TaskExecutor;
import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import com.mulesoft.connectors.a2a.internal.server.agent.response.MessageObject;
import com.mulesoft.connectors.a2a.internal.server.agent.response.TaskObject;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import com.mulesoft.connectors.a2a.internal.util.certificate.HttpUtils;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageExecutor
extends TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMessageExecutor.class);
    private final A2AProtocolSerializer messageSerializer;
    private final boolean historySupported;
    private final boolean taskHistoryEnabled;

    public SendMessageExecutor(TaskContext taskContext, boolean historySupported) {
        super(taskContext.getRequestContext(), taskContext.getResponseCallback(), taskContext.getRpcRequest(), taskContext.getSerializer(), taskContext.getTaskHistory(), taskContext.getTaskStoreService());
        this.messageSerializer = (A2AProtocolSerializer)taskContext.getMessageSerializer();
        this.taskHistoryEnabled = taskContext.isTaskHistoryEnabled();
        this.historySupported = historySupported;
    }

    @Override
    public RpcRequestContext execute() {
        RpcRequestContext context = new RpcRequestContext(this.rpcRequest, HttpUtils.buildRequestAttributes(this.httpRequestContext));
        context.getResponseFuture().whenComplete((response, t) -> {
            if (t != null) {
                ServerAgentUtils.sendExceptionalHttpResponse(this.rpcRequest, t, this.responseCallback, this.serializer);
            } else {
                try {
                    String responseBody = ServerAgentUtils.createResponseBody(this.rpcRequest, response, this.serializer);
                    if (response.getStatusCode() == 200 && this.historySupported && this.taskHistoryEnabled) {
                        this.updateTaskHistory(responseBody);
                    }
                    ServerAgentUtils.sendHttpResponse(response.getStatusCode(), responseBody, response.getHeaders(), this.responseCallback);
                }
                catch (Exception e) {
                    ServerAgentUtils.sendExceptionalHttpResponse(this.rpcRequest, e, this.responseCallback, this.serializer);
                }
            }
        });
        return context;
    }

    private void updateTaskHistory(String responseBody) throws Exception {
        try {
            JsonRpcResult result = this.messageSerializer.parseResult(responseBody);
            String requestMessage = this.messageSerializer.getJsonMessageFromRequest(this.rpcRequest.getParams());
            String responseMessage = this.messageSerializer.getJsonMessageFromResult(responseBody);
            if (null == result.getResult()) {
                throw new Exception("Response was neither of kind 'task' nor 'message'! Ensure that 'kind' field is returned in the response.");
            }
            Object object = result.getResult();
            if (object instanceof TaskObject) {
                TaskObject taskObject = (TaskObject)object;
                String taskId = taskObject.getId();
                if (taskId == null) {
                    LOGGER.error("Error updating task history! Required parameter 'id' not found in response task!");
                    return;
                }
                this.taskStoreService.updateTask(taskId, result.getResultJson());
                this.taskStoreService.updateHistory(taskId, requestMessage);
                this.taskStoreService.updateHistory(taskId, responseMessage);
            } else {
                String taskId = ((MessageObject)result.getResult()).getTaskId();
                if (taskId != null) {
                    this.taskStoreService.updateHistory(taskId, requestMessage);
                    this.taskStoreService.updateHistory(taskId, responseMessage);
                }
            }
        }
        catch (ObjectStoreException e) {
            LOGGER.error("Error updating task history due to object store failure", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Error updating task history due to unexpected error", (Throwable)e);
        }
    }
}

