/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.listener;

import com.mulesoft.connectors.a2a.api.certificate.CertificateData;
import com.mulesoft.connectors.a2a.internal.util.A2AUtils;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class RequestAttributes
implements Serializable {
    @Parameter
    private String taskId;
    @Parameter
    private String contextId;
    @Parameter
    @DisplayName(value="Query Parameters")
    @Summary(value="The query parameters received in the HTTP request")
    private MultiMap<String, String> queryParams;
    @Parameter
    @DisplayName(value="Headers")
    @Summary(value="The HTTP headers received in the request")
    private MultiMap<String, String> headers;
    @Parameter
    private String version;
    @Parameter
    private String scheme;
    @Parameter
    private String method;
    @Parameter
    private String localAddress;
    @Parameter
    private String remoteAddress;
    @Parameter
    @Optional
    private CertificateData clientCertificate;
    private final transient Supplier<CertificateData> clientCertificateSupplier;

    public RequestAttributes(String taskId, String contextId, MultiMap<String, String> queryParams, MultiMap<String, String> headers, String version, String scheme, String method, String localAddress, String remoteAddress, Supplier<CertificateData> clientCertificateSupplier) {
        this.taskId = taskId;
        this.contextId = contextId;
        this.queryParams = A2AUtils.copy(queryParams);
        this.headers = A2AUtils.copy(headers);
        this.version = version;
        this.scheme = scheme;
        this.method = method;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.clientCertificateSupplier = clientCertificateSupplier;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getMethod() {
        return this.method;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public CertificateData getClientCertificate() {
        if (this.clientCertificate == null && this.clientCertificateSupplier != null) {
            this.clientCertificate = this.clientCertificateSupplier.get();
        }
        return this.clientCertificate;
    }

    public boolean equals(Object object) {
        if (object instanceof RequestAttributes) {
            RequestAttributes that = (RequestAttributes)object;
            return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.contextId, that.contextId) && Objects.equals(this.headers, that.headers) && Objects.equals(this.version, that.version) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.method, that.method) && Objects.equals(this.localAddress, that.localAddress) && Objects.equals(this.remoteAddress, that.remoteAddress) && Objects.equals(this.getClientCertificate(), that.getClientCertificate());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.contextId, this.queryParams, this.headers, this.version, this.scheme, this.method, this.localAddress, this.remoteAddress, this.getClientCertificate());
    }
}

