/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.mulesoft.connectors.a2a.api.model.card.SecurityScheme;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="OpenId Connect Security Scheme")
public class OpenIdConnectSecurityScheme
extends SecurityScheme {
    private final String type = "openIdConnect";
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="OpenID Connect URL")
    @Summary(value="OpenID Connect URL to discover OAuth2 configuration values")
    private String openIdConnectUrl;

    @Override
    public OpenIdConnectSecurityScheme copy() {
        OpenIdConnectSecurityScheme copy = new OpenIdConnectSecurityScheme();
        copy.setSecuritySchemeName(this.getSecuritySchemeName());
        copy.setDescription(this.getDescription());
        copy.openIdConnectUrl = this.openIdConnectUrl;
        return copy;
    }

    @Override
    public String getType() {
        return "openIdConnect";
    }

    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public void setOpenIdConnectUrl(String openIdConnectUrl) {
        if (openIdConnectUrl == null || openIdConnectUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("OpenID Connect URL is required and cannot be null or empty");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OpenIdConnectSecurityScheme) {
            OpenIdConnectSecurityScheme openIdConnectSecurityScheme = (OpenIdConnectSecurityScheme)object;
            return super.equals(object) && Objects.equals(this.openIdConnectUrl, openIdConnectSecurityScheme.openIdConnectUrl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.openIdConnectUrl);
    }
}

