/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.client.connection;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.api.model.transport.RequestParameterGroup;
import com.mulesoft.connectors.a2a.api.model.transport.ResponseAttributes;
import com.mulesoft.connectors.a2a.internal.client.helper.AgentCardHelper;
import com.mulesoft.connectors.a2a.internal.client.helper.ResponseAttributesHelper;
import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.error.exception.AgentCardDiscoveryException;
import com.mulesoft.connectors.a2a.internal.error.exception.ClientException;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.tracing.TracingUtils;
import com.mulesoft.connectors.a2a.internal.util.A2AUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A2AClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(A2AClient.class);
    private String baseUrl;
    private final HttpClient httpClient;
    private final HttpRequestAuthentication authentication;
    private final HttpRequestOptions requestOptions;
    private final JsonRpcSerializer serializer;
    private final MultiMap<String, String> defaultHeaders;
    private final A2AProtocolSerializer a2aSerializer;
    private AgentCard agentCard;

    public A2AClient(String baseUrl, int responseTimeout, HttpClient httpClient, HttpRequestAuthentication authentication, MultiMap<String, String> defaultHeaders, JsonRpcSerializer serializer, A2AProtocolSerializer a2aSerializer) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.httpClient = httpClient;
        this.serializer = serializer;
        this.defaultHeaders = defaultHeaders != null ? MultiMap.unmodifiableMultiMap(defaultHeaders) : MultiMap.emptyMultiMap();
        this.a2aSerializer = a2aSerializer;
        HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptions.builder().responseTimeout(responseTimeout);
        if (authentication instanceof HttpAuthentication) {
            HttpAuthentication auth = (HttpAuthentication)authentication;
            optionsBuilder.authentication(auth);
            this.authentication = null;
        } else {
            this.authentication = authentication;
        }
        this.requestOptions = optionsBuilder.build();
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    public CompletableFuture<Result<String, ResponseAttributes>> sendMessage(InputStream message, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("message/send", message, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getTask(InputStream query, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("tasks/get", query, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getPushNotificationConfig(InputStream taskQuery, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doPushNotificationRequest("tasks/pushNotificationConfig/get", taskQuery, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> listPushNotificationConfigs(InputStream taskQuery, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doPushNotificationRequest("tasks/pushNotificationConfig/list", taskQuery, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> deletePushNotificationConfig(InputStream taskQuery, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doPushNotificationRequest("tasks/pushNotificationConfig/delete", taskQuery, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> setPushNotificationConfig(InputStream taskPushNotificationConfig, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doPushNotificationRequest("tasks/pushNotificationConfig/set", taskPushNotificationConfig, requestParameters, traceContextManager);
    }

    private CompletableFuture<Result<String, ResponseAttributes>> doPushNotificationRequest(String method, InputStream request, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        if (this.agentCard != null && this.agentCard.getCapabilities().isPushNotifications()) {
            return this.doRequest(method, request, requestParameters, traceContextManager);
        }
        return CompletableFuture.failedFuture((Throwable)new ModuleException("Operation not permitted: Push Notifications", (ErrorTypeDefinition)A2AErrorTypes.PUSH_NOTIFICATION_UNSUPPORTED));
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getCard(boolean useExtendedCard, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.getAgentCard(useExtendedCard, false, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getCard(boolean useExtendedCard, boolean setBaseUrl, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.getAgentCard(useExtendedCard, setBaseUrl, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> cancelTask(InputStream taskId, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doRequest("tasks/cancel", taskId, requestParameters, traceContextManager);
    }

    private CompletableFuture<Result<String, ResponseAttributes>> doRequest(String method, Object params, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        return this.doRequest(HttpConstants.Method.POST, "", method, params, requestParameters, traceContextManager);
    }

    private CompletableFuture<Result<String, ResponseAttributes>> doRequest(HttpConstants.Method httpMethod, String uri, String method, Object params, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        CompletableFuture<Result<String, ResponseAttributes>> future = new CompletableFuture<Result<String, ResponseAttributes>>();
        HttpRequestBuilder requestBuilder = ((HttpRequestBuilder)A2AUtils.newRequestBuilder(this.authentication).uri(this.baseUrl + uri).addHeader("Content-Type", "application/json")).method(httpMethod);
        if (requestParameters != null) {
            requestBuilder.headers(requestParameters.getAdditionalProperties());
        }
        this.defaultHeaders.toListValuesMap().forEach((arg_0, arg_1) -> ((HttpRequestBuilder)requestBuilder).addHeaders(arg_0, arg_1));
        TracingUtils.propagateTraceContext(requestBuilder, traceContextManager);
        if (httpMethod == HttpConstants.Method.POST) {
            requestBuilder.entity((HttpEntity)new InputStreamHttpEntity(this.serializer.writeJsonRequest(method, params)));
        }
        HttpRequest request = requestBuilder.build();
        TracingUtils.traceOutboundRequest(traceContextManager, request);
        this.httpClient.sendAsync(request, this.requestOptions).whenComplete((response, e) -> {
            try {
                JsonRpcError rpcError;
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                    return;
                }
                int statusCode = response.getStatusCode();
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                if (statusCode == HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()) {
                    ResponseAttributes responseAttributes = ResponseAttributesHelper.createFromHttpResponse(response);
                    future.completeExceptionally((Throwable)((Object)new ClientException(content, A2AErrorTypes.UNAUTHORIZED, content, responseAttributes)));
                    return;
                }
                if (httpMethod == HttpConstants.Method.GET) {
                    future.complete(Result.builder().output((Object)content).attributes((Object)ResponseAttributesHelper.createFromHttpResponse(response)).build());
                    return;
                }
                if ((statusCode >= 400 || statusCode == 200 && content.contains("\"error\":")) && (rpcError = this.serializer.getJsonResponseError(content)) != null) {
                    ResponseAttributes responseAttributes = ResponseAttributesHelper.createFromHttpResponse(response);
                    future.completeExceptionally((Throwable)((Object)new ClientException(rpcError.codeAndMessage(), A2AErrorTypes.fromRpcErrorCode(rpcError.getCode()), content, responseAttributes)));
                    return;
                }
                if (statusCode >= 200 && statusCode < 300) {
                    future.complete(Result.builder().output((Object)this.serializer.getJsonResponseResult(content)).attributes((Object)ResponseAttributesHelper.createFromHttpResponse(response)).build());
                } else {
                    ResponseAttributes responseAttributes = ResponseAttributesHelper.createFromHttpResponse(response);
                    future.completeExceptionally((Throwable)((Object)new ClientException("Invalid response status code: " + statusCode, A2AErrorTypes.INTERNAL_ERROR, content, responseAttributes)));
                }
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    private CompletableFuture<Result<String, ResponseAttributes>> getCardResponse(boolean useExtendedCard, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        if (!useExtendedCard) {
            return this.doRequest(HttpConstants.Method.GET, ".well-known/agent-card.json", null, null, requestParameters, traceContextManager);
        }
        return this.doRequest(HttpConstants.Method.GET, "agent/authenticatedExtendedCard", null, null, requestParameters, traceContextManager);
    }

    public CompletableFuture<Result<String, ResponseAttributes>> getAgentCard(boolean useExtendedCard, boolean setBaseUrl, RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager) {
        CompletableFuture<Result<String, ResponseAttributes>> future = new CompletableFuture<Result<String, ResponseAttributes>>();
        try {
            URI requestUri = AgentCardHelper.validateServerUrl(this.baseUrl);
            this.getCardResponse(useExtendedCard, requestParameters, traceContextManager).whenComplete((result, throwable) -> {
                try {
                    if (throwable != null) {
                        future.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    AgentCard card = AgentCardHelper.handleAgentCardResponse(requestUri, (Result<String, ResponseAttributes>)result, this.a2aSerializer);
                    if (setBaseUrl) {
                        this.setBaseUrl(card.getUrl());
                        this.agentCard = card;
                        LOGGER.info("Using service URL from agent card: {}", (Object)card.getUrl());
                    }
                    future.complete((Result<String, ResponseAttributes>)result);
                }
                catch (Exception e) {
                    if (e instanceof AgentCardDiscoveryException.InvalidAgentCardException) {
                        String responseBody = result.getOutput() != null ? (String)result.getOutput() : "";
                        ResponseAttributes responseAttributes = result.getAttributes().orElse(null);
                        future.completeExceptionally((Throwable)((Object)new ClientException(e.getMessage(), A2AErrorTypes.INVALID_AGENT_CARD, responseBody, responseAttributes)));
                    }
                    future.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public String getServiceUrl() {
        return this.baseUrl;
    }
}

