/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.client.connection.provider;

import com.mulesoft.connectors.a2a.internal.client.connection.A2AClient;
import com.mulesoft.connectors.a2a.internal.error.exception.AgentCardDiscoveryException;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.connectivity.CachedConnectionProvider;
import org.mule.sdk.api.connectivity.ConnectionValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="client-connection")
public class ClientConnectionProvider
implements CachedConnectionProvider<A2AClient>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectionProvider.class);
    @Inject
    private HttpService httpService;
    @Inject
    private MuleContext muleContext;
    @Inject
    private JsonRpcSerializer jsonRpcSerializer;
    @Inject
    private A2AProtocolSerializer a2aProtocolSerializer;
    @RefName
    String refName;
    @Parameter
    @Summary(value="The base URL for the target A2A server")
    String serverUrl;
    @Parameter
    @Optional(defaultValue="30")
    @Summary(value="Sets the duration to wait for server responses before timing out requests.")
    Integer requestTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Summary(value="Time Unit for the requestTimeout parameter")
    TimeUnit requestTimeoutUnit;
    @Parameter
    @Optional
    @Placement(tab="TLS")
    TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Placement(tab="Authentication")
    HttpRequestAuthentication authentication;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private MultiMap<String, String> defaultHeaders = MultiMap.emptyMultiMap();
    private HttpClient httpClient;

    public A2AClient connect() throws ConnectionException {
        try {
            A2AClient a2aClient = new A2AClient(this.serverUrl, (int)this.requestTimeoutUnit.toMillis(this.requestTimeout.intValue()), this.httpClient, this.authentication, this.defaultHeaders, this.jsonRpcSerializer, this.a2aProtocolSerializer);
            LOGGER.debug("Discovering agent card from {}", (Object)this.serverUrl);
            a2aClient.getCard(false, true, null, null).get();
            return a2aClient;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AgentCardDiscoveryException) {
                LOGGER.error("Failed to discover agent card from {}", (Object)this.serverUrl, (Object)cause);
                throw new ConnectionException("Failed to discover agent card: " + cause.getMessage(), cause);
            }
            LOGGER.error("Unexpected error while connecting to {}", (Object)this.serverUrl, (Object)e);
            throw new ConnectionException("Failed to connect: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while connecting to {}", (Object)this.serverUrl, (Object)e);
            throw new ConnectionException("Interrupted while connecting: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while connecting to {}", (Object)this.serverUrl, (Object)e);
            throw new ConnectionException("Failed to connect: " + e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect(A2AClient client) {
        LOGGER.debug("Disconnect called for A2A client - resources managed by lifecycle");
    }

    public ConnectionValidationResult validate(A2AClient client) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
        LifecycleUtils.initialiseIfNeeded((Object)this.authentication, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName("a2a-http-client-" + this.refName).setStreaming(true).setTlsContextFactory(this.tlsContextFactory).build());
        this.httpClient.start();
        LifecycleUtils.startIfNeeded((Object)this.authentication);
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
        LifecycleUtils.stopIfNeeded((Object)this.authentication);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.authentication, (Logger)LOGGER);
    }

    void setServerUrl(String url) {
        this.serverUrl = url;
    }
}

