/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.ServerConfig;
import com.mulesoft.connectors.a2a.internal.server.TaskHistoryParameterGroup;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.DeletePushNotificationConfigHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.GetPushNotificationConfigHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.GetRequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.RequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.SendMessageHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.SetPushNotificationConfigHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.DefaultTaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.DefaultTaskStoreServiceImpl;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.NullTaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskStoreService;
import com.mulesoft.connectors.a2a.internal.server.agent.response.MessageObject;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import com.mulesoft.connectors.a2a.internal.tracing.InboundSpanCustomizer;
import com.mulesoft.connectors.a2a.internal.util.certificate.HttpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAgent.class);
    private Map<String, RequestHandler> methodHandlers;
    private final HttpServer httpServer;
    private final HttpClient httpClient;
    private final String path;
    private final JsonRpcSerializer serializer;
    private final A2AProtocolSerializer messageSerializer;
    private final LockFactory lockFactory;
    private final ObjectStoreManager objectStoreManager;
    private final List<RequestHandlerManager> requestHandlers = new ArrayList<RequestHandlerManager>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private Consumer<RpcRequestContext> onMessage;
    private Function<RpcRequestContext, CompletableFuture<EffectivePushNotificationConfig>> pushNotificationHandler;
    private AgentCard card;
    private ComponentLocation listenerComponentLocation;
    private TaskRepository taskRepository;
    private TaskStoreService taskStoreService;
    private boolean taskHistoryEnabled;

    public ServerAgent(HttpServer httpServer, String path, JsonRpcSerializer serializer, A2AProtocolSerializer messageSerializer, LockFactory lockFactory, ObjectStoreManager objectStoreManager, HttpClient client) {
        this.httpServer = httpServer;
        this.path = path.endsWith("/") ? path : path + "/";
        this.serializer = serializer;
        this.lockFactory = lockFactory;
        this.objectStoreManager = objectStoreManager;
        this.messageSerializer = messageSerializer;
        this.httpClient = client;
    }

    public void initServer(ServerConfig config, ComponentLocation listenerComponentLocation, Consumer<RpcRequestContext> onRequest) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Server has already been initialized.");
        }
        if (this.listenerComponentLocation != null) {
            throw new IllegalStateException("A task listener already exists for config %s. Only one can be defined per <a2a:server-config> element".formatted(config.getConfigName()));
        }
        this.listenerComponentLocation = listenerComponentLocation;
        this.card = config.getCard().copy();
        this.taskRepository = this.createTaskRepositoryObjectStore(config);
        this.methodHandlers = Map.of("message/send", new SendMessageHandler(this.taskHistoryEnabled, this.httpClient), "tasks/get", new GetRequestHandler(), "tasks/pushNotificationConfig/set", new SetPushNotificationConfigHandler(), "tasks/pushNotificationConfig/get", new GetPushNotificationConfigHandler(false), "tasks/pushNotificationConfig/list", new GetPushNotificationConfigHandler(true), "tasks/pushNotificationConfig/delete", new DeletePushNotificationConfigHandler());
        this.taskStoreService = new DefaultTaskStoreServiceImpl(this.taskRepository);
        try {
            this.requestHandlers.add(this.createCardRequestHandler());
            this.requestHandlers.add(this.createTaskRequestHandler());
        }
        catch (Exception e) {
            this.stop();
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Failed to create request handlers for config " + config.getConfigName())), (Throwable)e);
        }
        this.onMessage = onRequest;
    }

    public void setPushNotificationHandler(Function<RpcRequestContext, CompletableFuture<EffectivePushNotificationConfig>> handler) {
        if (this.pushNotificationHandler != null) {
            throw new IllegalStateException("PushNotificationHandler already set");
        }
        this.pushNotificationHandler = handler;
    }

    public void removePushNotificationHandler() {
        this.pushNotificationHandler = null;
    }

    public void addTracingData(RpcRequestContext context, DistributedTraceContextManager traceManager) {
        ServerAddress serverAddress = this.httpServer.getServerAddress();
        new InboundSpanCustomizer(traceManager, this.path, serverAddress.getIp(), serverAddress.getPort(), this.httpServer.getProtocol().toString(), this.httpServer.getProtocol().getScheme(), context.getRequestAttributes().getHeaders(), "POST").customizeSpan();
    }

    private TaskRepository createTaskRepositoryObjectStore(ServerConfig serverConfig) {
        TaskHistoryParameterGroup repositoryConfig = serverConfig.getTaskHistory();
        this.taskHistoryEnabled = repositoryConfig.isTaskHistoryEnabled();
        if (!this.taskHistoryEnabled && !serverConfig.getCard().getCapabilities().isPushNotifications()) {
            return NullTaskRepository.INSTANCE;
        }
        ObjectStore os = repositoryConfig.getTaskRepositoryObjectStore();
        if (os == null) {
            try {
                os = this.objectStoreManager.getOrCreateObjectStore("_a2a-taskRepository-" + serverConfig.getConfigName(), ObjectStoreSettings.builder().maxEntries(repositoryConfig.getDefaultMaxHistoryLength()).persistent(false).entryTtl(Long.valueOf(TimeUnit.DAYS.toMillis(1L))).build());
                os.open();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Failed to create default task repository store for config " + serverConfig.getConfigName())), (Throwable)e);
            }
        }
        return new DefaultTaskRepository((ObjectStore<TaskRepositoryItem>)os, this.lockFactory, serverConfig.getConfigName());
    }

    private RequestHandlerManager createTaskRequestHandler() {
        RequestHandlerManager handler = this.httpServer.addRequestHandler(List.of("POST"), this.path, (httpRequestContext, responseCallback) -> {
            JsonRpcRequest jsonRequest;
            HttpRequest httpRequest = httpRequestContext.getRequest();
            try {
                jsonRequest = this.serializer.parseRpcRequest(httpRequest.getEntity().getContent());
            }
            catch (Exception e) {
                LOGGER.error("Error parsing request", (Throwable)e);
                JsonRpcRequest rpcRequest = new JsonRpcRequest();
                rpcRequest.id = null;
                ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.PARSE_ERROR, "Invalid JSON payload", rpcRequest, responseCallback, this.serializer);
                return;
            }
            try {
                jsonRequest.validate();
            }
            catch (IllegalArgumentException e) {
                ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.INVALID_REQUEST, e.getMessage(), jsonRequest, responseCallback, this.serializer);
                return;
            }
            RequestHandler requestHandler = this.methodHandlers.get(jsonRequest.getMethod());
            if (requestHandler == null) {
                ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.METHOD_NOT_FOUND, "Method not found or unsupported - " + jsonRequest.getMethod(), jsonRequest, responseCallback, this.serializer);
                return;
            }
            String taskId = null;
            String contextId = null;
            try {
                if ("tasks/pushNotificationConfig/set".equals(jsonRequest.getMethod())) {
                    taskId = this.messageSerializer.extractTaskIdForPushNotificationConfig(jsonRequest.getParams());
                    if (taskId == null || taskId.trim().isEmpty()) {
                        throw new IllegalArgumentException("TaskID cannot be null or empty for tasks/pushNotificationConfig/set!");
                    }
                } else if ("message/send".equals(jsonRequest.getMethod())) {
                    MessageObject requestMessage = this.messageSerializer.extractMessageFromParams(jsonRequest.getParams());
                    taskId = requestMessage.getTaskId();
                    contextId = requestMessage.getContextId();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error extracting task id from request", (Throwable)e);
                ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.INVALID_REQUEST, e.getMessage(), jsonRequest, responseCallback, this.serializer);
                return;
            }
            RpcRequestContext rpcRequestContext = new RpcRequestContext(jsonRequest, HttpUtils.buildRequestAttributes(taskId, contextId, httpRequestContext));
            RequestHandlerContext handlerContext = this.createHandlerContext(httpRequestContext, rpcRequestContext, responseCallback);
            requestHandler.execute(handlerContext);
        });
        handler.start();
        return handler;
    }

    private RequestHandlerContext createHandlerContext(HttpRequestContext requestContext, RpcRequestContext rpcRequestContext, HttpResponseReadyCallback responseCallback) {
        if (null == this.pushNotificationHandler) {
            this.pushNotificationHandler = this::onPushNotificationDefault;
        }
        return RequestHandlerContext.builder().agentCard(this.getCard()).requestContext(requestContext).responseCallback(responseCallback).taskStoreService(this.taskStoreService).taskRepository(this.taskRepository).serializer(this.serializer).messageSerializer(this.messageSerializer).messageHandler(this.onMessage).onSetPushNotificationConfigHandler(this.pushNotificationHandler).rpcRequestContext(rpcRequestContext).build();
    }

    private RequestHandlerManager createCardRequestHandler() {
        try {
            String jsonCard = this.messageSerializer.toAgentCardJson(this.card);
            RequestHandlerManager handler = this.httpServer.addRequestHandler(List.of("GET"), this.path + ".well-known/agent-card.json", (requestContext, responseCallback) -> ServerAgentUtils.sendHttpResponse(200, jsonCard, responseCallback));
            handler.start();
            return handler;
        }
        catch (Exception e) {
            LOGGER.error("Error creating card request handler", (Throwable)e);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to create card request handler"), (Throwable)e);
        }
    }

    public void stop() {
        this.requestHandlers.forEach(handler -> {
            try {
                handler.stop();
                handler.dispose();
            }
            catch (Exception e) {
                LOGGER.error("Error stopping request handler", (Throwable)e);
            }
        });
        this.requestHandlers.clear();
        this.listenerComponentLocation = null;
        this.taskRepository.close();
        this.onMessage = null;
    }

    public AgentCard getCard() {
        return this.card;
    }

    public String getPath() {
        return this.path;
    }

    public JsonRpcSerializer getSerializer() {
        return this.serializer;
    }

    public A2AProtocolSerializer getA2aSerializer() {
        return this.messageSerializer;
    }

    private CompletableFuture<EffectivePushNotificationConfig> onPushNotificationDefault(RpcRequestContext context) {
        CompletableFuture<EffectivePushNotificationConfig> future = new CompletableFuture<EffectivePushNotificationConfig>();
        String paramsJson = context.getRequest().getParams();
        String pushConfigJson = this.getA2aSerializer().extractPushNotificationConfigJson(paramsJson);
        EffectivePushNotificationConfig pushConfig = null;
        try {
            pushConfig = this.getA2aSerializer().parsePushNotificationConfig(pushConfigJson);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        future.complete(pushConfig);
        return future;
    }
}

