/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.RequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.HandlerUtils;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPushNotificationConfigHandler
extends RequestHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GetPushNotificationConfigHandler.class);
    private final Boolean fetchAllNotificationConfigs;

    public GetPushNotificationConfigHandler(boolean fetchAllNotificationConfigs) {
        this.fetchAllNotificationConfigs = fetchAllNotificationConfigs;
    }

    @Override
    public void execute(RequestHandlerContext requestHandlerContext) {
        LOGGER.debug("Fetching pushNotificationConfigs for task...");
        RpcRequestContext context = requestHandlerContext.getRpcRequestContext();
        JsonRpcRequest rpcRequest = context.getRequest();
        HandlerUtils.setupResponseHandler(requestHandlerContext);
        if (!requestHandlerContext.getAgentCard().getCapabilities().isPushNotifications()) {
            HandlerUtils.handlePushNotificationNotSupported(context);
            return;
        }
        String taskId = HandlerUtils.getTaskIdFromPushConfigRequest(requestHandlerContext.getA2aSerializer(), rpcRequest);
        String pushNotificationConfigId = HandlerUtils.getPushConfigIdFromPushConfigRequest(requestHandlerContext.getA2aSerializer(), rpcRequest);
        try {
            requestHandlerContext.getTaskRepository().get(taskId).ifPresentOrElse(item -> {
                LOGGER.debug("Task found in history - taskId: {}", (Object)taskId);
                this.getPushNotificationConfigs(requestHandlerContext, (TaskRepositoryItem)item, taskId, pushNotificationConfigId);
            }, () -> HandlerUtils.handleTaskNotFound(context));
        }
        catch (ObjectStoreException e) {
            LOGGER.error("ObjectStore failed to retrieve task with id: {}", (Object)taskId, (Object)e);
            HandlerUtils.handleInternalError(context, e);
        }
    }

    public void getPushNotificationConfigs(RequestHandlerContext requestHandlerContext, TaskRepositoryItem item, String taskId, String pushNotificationConfigId) {
        try {
            List<EffectivePushNotificationConfig> pushNotificationConfigs = item.getPushNotificationConfigs();
            String response = null;
            if (this.fetchAllNotificationConfigs.booleanValue()) {
                response = requestHandlerContext.getA2aSerializer().transformPushNotificationConfigListResponse(taskId, pushNotificationConfigs);
            } else {
                EffectivePushNotificationConfig pushNotificationConfig;
                if (pushNotificationConfigId != null) {
                    pushNotificationConfig = pushNotificationConfigs.stream().filter(pnConfig -> pnConfig.getId().equals(pushNotificationConfigId)).findFirst().orElse(null);
                    if (pushNotificationConfig == null) {
                        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().get(), "Push notification config not found!");
                        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()).error(error).build();
                        requestHandlerContext.getRpcRequestContext().getResponseFuture().complete(errorResponse);
                        return;
                    }
                } else {
                    pushNotificationConfig = pushNotificationConfigs.get(pushNotificationConfigs.size() - 1);
                }
                response = requestHandlerContext.getA2aSerializer().transformPushNotificationConfigResponse(taskId, pushNotificationConfig);
            }
            RpcRequestContext.Response successResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.OK.getStatusCode()).body(new ByteArrayInputStream(response.getBytes())).build();
            requestHandlerContext.getRpcRequestContext().getResponseFuture().complete(successResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to transform task history response", (Throwable)e);
            HandlerUtils.handleInternalError(requestHandlerContext.getRpcRequestContext(), e);
        }
    }
}

