/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.push;

import com.mulesoft.connectors.a2a.internal.util.A2AUtils;
import java.io.Serializable;
import java.util.Objects;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.proxy.HttpProxyConfig;
import org.mule.runtime.api.util.MultiMap;

public class EffectivePushNotificationConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String id;
    private String token;
    private MultiMap<String, String> additionalHeaders;
    private HttpRequestAuthentication authentication;
    private int timeout;
    private HttpProxyConfig proxyConfig;

    public EffectivePushNotificationConfig() {
    }

    public EffectivePushNotificationConfig(Builder builder) {
        this.url = builder.url;
        this.id = builder.id;
        this.token = builder.token;
        this.additionalHeaders = A2AUtils.copy(builder.additionalHeaders);
        this.proxyConfig = builder.proxyConfig;
        this.authentication = builder.authentication;
        this.timeout = builder.timeout;
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public MultiMap<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public HttpRequestAuthentication getAuthentication() {
        return this.authentication;
    }

    public HttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setUrl(String url) {
        if (null == url || url.trim().isEmpty()) {
            throw new IllegalArgumentException("push notification config url cannot be null or empty!");
        }
        this.url = url;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAdditionalHeaders(MultiMap<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setProxyConfig(HttpProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EffectivePushNotificationConfig)) {
            return false;
        }
        EffectivePushNotificationConfig that = (EffectivePushNotificationConfig)o;
        return this.timeout == that.timeout && Objects.equals(this.url, that.url) && Objects.equals(this.id, that.id) && Objects.equals(this.token, that.token) && Objects.equals(this.additionalHeaders, that.additionalHeaders) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.proxyConfig, that.proxyConfig);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.id, this.token, this.additionalHeaders, this.authentication, this.timeout, this.proxyConfig);
    }

    public static class Builder {
        private String url;
        private String id;
        private String token;
        private MultiMap<String, String> additionalHeaders;
        private HttpRequestAuthentication authentication;
        private int timeout;
        private HttpProxyConfig proxyConfig;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder additionalHeaders(MultiMap<String, String> additionalHeaders) {
            this.additionalHeaders = A2AUtils.copy(additionalHeaders);
            return this;
        }

        public Builder authentication(HttpRequestAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder proxyConfig(HttpProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public EffectivePushNotificationConfig build() {
            return new EffectivePushNotificationConfig(this);
        }
    }
}

