/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.repository;

import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.util.ObjectStoreAccessor;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskRepository
implements TaskRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskRepository.class);
    private final ObjectStoreAccessor<TaskRepositoryItem> taskObjectStoreAccessor;
    private final String ownerConfigName;
    private final LockFactory lockFactory;
    private final Function<String, String> lockKeyFunction;

    public DefaultTaskRepository(ObjectStore<TaskRepositoryItem> taskObjectStore, LockFactory lockFactory, String ownerConfigName) {
        this.taskObjectStoreAccessor = new ObjectStoreAccessor<TaskRepositoryItem>(taskObjectStore, lockFactory, taskId -> "_a2a-taskRepository-" + ownerConfigName + "-" + taskId);
        this.ownerConfigName = ownerConfigName;
        this.lockFactory = lockFactory;
        this.lockKeyFunction = taskId -> "_a2a-defaultTaskRepository-" + ownerConfigName + "-" + taskId;
    }

    @Override
    public void upsert(String taskId, TaskRepositoryItem item) throws ObjectStoreException {
        this.taskObjectStoreAccessor.upsert(taskId, item);
    }

    @Override
    public Optional<TaskRepositoryItem> get(String taskId) throws ObjectNotFoundException, ObjectStoreException {
        return this.taskObjectStoreAccessor.get(taskId);
    }

    @Override
    public void remove(String taskId) throws ObjectStoreException {
        try {
            this.taskObjectStoreAccessor.remove(taskId);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.debug("Could not remove task with id {} because it doesn't exist. Resuming...", (Object)taskId);
        }
    }

    @Override
    public void apply(String taskId, CheckedRunnable function) {
        this.withLock(taskId, function);
    }

    @Override
    public void close() {
        try {
            this.taskObjectStoreAccessor.close();
        }
        catch (Exception e) {
            LOGGER.error("Error closing task store for config {}", (Object)this.ownerConfigName, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withLock(String id, CheckedRunnable supplier) {
        Lock lock = this.lockFactory.createLock(this.lockKeyFunction.apply(id));
        lock.lock();
        try {
            supplier.run();
        }
        finally {
            lock.unlock();
        }
    }
}

