/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.connection.http;

import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.server.agent.ServerAgent;
import com.mulesoft.connectors.a2a.internal.server.listener.push.model.ServerPushNotificationConfigParameterGroup;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.semantics.connectivity.UrlPath;

public class HttpServerConnectionProvider
implements CachedConnectionProvider<ServerAgent>,
Lifecycle,
NoConnectivityTest {
    @Inject
    private HttpService httpService;
    private HttpClient notificationHttpClient;
    @Inject
    private JsonRpcSerializer jsonRpcSerializer;
    @Inject
    private A2AProtocolSerializer messageSerializer;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private Registry registry;
    @RefName
    private String refName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ConfigReference(name="LISTENER_CONFIG", namespace="HTTP")
    @Summary(value="Reference to the <http:listener-config> used to expose the inbound endpoint")
    private String listenerConfig;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @UrlPath
    private String agentPath;
    @ParameterGroup(name="Push Notifications", showInDsl=true)
    private ServerPushNotificationConfigParameterGroup pushNotification;

    public ServerAgent connect() {
        try {
            return new ServerAgent(this.httpService.getServerFactory().lookup(this.listenerConfig), this.agentPath, this.jsonRpcSerializer, this.messageSerializer, this.lockFactory, this.objectStoreManager, this.notificationHttpClient);
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find <http:listener-config> named '%s'".formatted(this.listenerConfig), (Object[])new Object[]{e}));
        }
    }

    public void disconnect(ServerAgent server) {
        server.stop();
    }

    public ConnectionValidationResult validate(ServerAgent server) {
        return ConnectionValidationResult.success();
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        TlsContextFactory factory = null;
        if (null != this.pushNotification.getTlsContextRef()) {
            Optional registryTLS = this.registry.lookupByName(this.pushNotification.getTlsContextRef());
            if (registryTLS.isPresent()) {
                factory = (TlsContextFactory)registryTLS.get();
            } else {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TLS Context not found in the registry!"), (Initialisable)this);
            }
        }
        this.notificationHttpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName("a2a-http-notification-client-" + this.refName).setTlsContextFactory(factory).setStreaming(true).build());
    }

    public void start() throws MuleException {
        if (this.notificationHttpClient != null) {
            this.notificationHttpClient.start();
        }
    }

    public void stop() throws MuleException {
        if (this.notificationHttpClient != null) {
            this.notificationHttpClient.stop();
        }
    }
}

