/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.listener;

import com.mulesoft.connectors.a2a.internal.server.ServerConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.ServerAgent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServerListener<T, A>
extends Source<T, A>
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseServerListener.class);
    protected static final String REQUEST_CONTEXT_VAR = "_requestContext";
    @Config
    protected ServerConfig config;
    @Connection
    protected ConnectionProvider<ServerAgent> connectionProvider;
    private String dslTag;
    protected ServerAgent serverAgent;
    protected ComponentLocation componentLocation;

    public final void initialise() throws InitialisationException {
        LOGGER.debug("Initialising BaseServerListener");
        ComponentIdentifier identifier = this.componentLocation.getComponentIdentifier().getIdentifier();
        this.dslTag = "<" + identifier.getNamespace() + ":" + identifier.getName() + ">";
        try {
            this.serverAgent = (ServerAgent)this.connectionProvider.connect();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void storeInContext(RpcRequestContext request, SourceCallbackContext context) {
        context.addVariable(REQUEST_CONTEXT_VAR, (Object)request);
    }

    protected RpcRequestContext recoverRequestContext(SourceCallbackContext context) {
        return (RpcRequestContext)context.getVariable(REQUEST_CONTEXT_VAR).orElseThrow(() -> new IllegalStateException("Request context not found in the source callback context."));
    }

    protected String getDslTag() {
        return this.dslTag;
    }
}

