/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.listener.push;

import com.mulesoft.connectors.a2a.api.listener.RequestAttributes;
import com.mulesoft.connectors.a2a.internal.datasense.PushNotificationConfigOutputResolver;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.listener.BaseServerListener;
import com.mulesoft.connectors.a2a.internal.server.listener.push.model.AcceptedPushNotificationConfigParameterGroup;
import com.mulesoft.connectors.a2a.internal.util.certificate.HttpUtils;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="On Push Notification Set Listener")
@MetadataScope(outputResolver=PushNotificationConfigOutputResolver.class)
@MediaType(value="application/json")
public class PushNotificationConfigListener
extends BaseServerListener<String, RequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushNotificationConfigListener.class);
    private static final String PUSH_CONFIG_VAR = "_pushConfig";
    private static final String FUTURE_VAR = "_effectiveConfigFuture";
    private SourceCallback<String, RequestAttributes> sourceCallback;

    private CompletableFuture<EffectivePushNotificationConfig> onPushNotification(RpcRequestContext requestContext) {
        if (this.sourceCallback == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("%s at %s is stopped".formatted(this.getDslTag(), this.componentLocation.getLocation())));
        }
        SourceCallbackContext context = this.sourceCallback.createContext();
        CompletableFuture<EffectivePushNotificationConfig> future = new CompletableFuture<EffectivePushNotificationConfig>();
        context.addVariable(FUTURE_VAR, future);
        String paramsJson = requestContext.getRequest().getParams();
        String pushConfigJson = this.serverAgent.getA2aSerializer().extractPushNotificationConfigJson(paramsJson);
        EffectivePushNotificationConfig pushConfig = null;
        try {
            pushConfig = this.serverAgent.getA2aSerializer().parsePushNotificationConfig(pushConfigJson);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        context.addVariable(PUSH_CONFIG_VAR, (Object)pushConfig);
        this.sourceCallback.handle(Result.builder().output((Object)requestContext.getRequest().getParams()).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON).attributes((Object)requestContext.getRequestAttributes()).attributesMediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).build(), context);
        return future;
    }

    public void onStart(SourceCallback<String, RequestAttributes> sourceCallback) throws MuleException {
        this.serverAgent.setPushNotificationHandler(this::onPushNotification);
        this.sourceCallback = sourceCallback;
    }

    public void onStop() {
        this.serverAgent.removePushNotificationHandler();
        this.sourceCallback = null;
    }

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="On Config Accepted", showInDsl=true) AcceptedPushNotificationConfigParameterGroup onConfigAccepted, SourceCallbackContext context) {
        EffectivePushNotificationConfig originalConfig = (EffectivePushNotificationConfig)context.getVariable(PUSH_CONFIG_VAR).get();
        String finalUrl = originalConfig.getUrl();
        if (!HttpUtils.isValidUrl(finalUrl)) {
            Object errorMessage = StringUtils.isBlank((String)finalUrl) ? "Push notification URL is required but was empty or null" : "Invalid push notification URL: " + finalUrl + ". URL must be a valid HTTP or HTTPS URL.";
            throw new IllegalArgumentException((String)errorMessage);
        }
        MultiMap<String, String> finalHeaders = onConfigAccepted.getAdditionalHeaders().isEmpty() ? originalConfig.getAdditionalHeaders() : onConfigAccepted.getAdditionalHeaders();
        EffectivePushNotificationConfig effectiveConfig = new EffectivePushNotificationConfig.Builder().url(finalUrl).id(originalConfig.getId()).additionalHeaders(finalHeaders).token(originalConfig.getToken()).authentication(onConfigAccepted.getAuthentication()).timeout(onConfigAccepted.getResponseTimeoutMillis()).proxyConfig(onConfigAccepted.getProxyConfig()).build();
        this.recoverFuture(context).complete(effectiveConfig);
    }

    @OnError
    public void onError(Error error, SourceCallbackContext context) {
        this.recoverFuture(context).completeExceptionally(error.getCause());
    }

    @OnTerminate
    public void onTerminate() {
    }

    private CompletableFuture<EffectivePushNotificationConfig> recoverFuture(SourceCallbackContext context) {
        return (CompletableFuture)context.getVariable(FUTURE_VAR).get();
    }
}

