/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.listener.task;

import com.mulesoft.connectors.a2a.api.listener.RequestAttributes;
import com.mulesoft.connectors.a2a.internal.datasense.MessageSendParamsOutputResolver;
import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.error.ErrorUtils;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.listener.BaseServerListener;
import com.mulesoft.connectors.a2a.internal.server.listener.task.model.TaskErrorResponseParameterGroup;
import com.mulesoft.connectors.a2a.internal.server.listener.task.model.TaskResponseParameterGroup;
import com.mulesoft.connectors.a2a.internal.tracing.TracingUtils;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="Task Listener")
@EmitsResponse
@MetadataScope(outputResolver=MessageSendParamsOutputResolver.class)
@MediaType(value="application/json")
public class TaskListener
extends BaseServerListener<String, RequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskListener.class);

    public void onStart(SourceCallback<String, RequestAttributes> sourceCallback) throws MuleException {
        try {
            this.serverAgent.initServer(this.config, this.componentLocation, request -> {
                SourceCallbackContext context = sourceCallback.createContext();
                this.storeInContext((RpcRequestContext)request, context);
                context.addVariable("_requestContext", request);
                this.serverAgent.addTracingData((RpcRequestContext)request, context.getDistributedSourceTraceContext());
                sourceCallback.handle(Result.builder().output((Object)request.getRequest().getParams()).mediaType(org.mule.runtime.api.metadata.MediaType.JSON).attributes((Object)request.getRequestAttributes()).attributesMediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).build(), context);
            });
        }
        catch (IllegalStateException e) {
            throw new DefaultMuleException("Only one <a2a:task-listener> is allowed per <a2a:server-config> element.", (Throwable)e);
        }
    }

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="Response", showInDsl=true) TaskResponseParameterGroup response, SourceCallbackContext context, DistributedTraceContextManager traceContextManager) {
        TracingUtils.traceResponseStatusCode(traceContextManager, 200, LOGGER);
        RpcRequestContext requestContext = this.recoverRequestContext(context);
        requestContext.getResponseFuture().complete(RpcRequestContext.Response.builder().body(response.getResponse()).headers(response.getResponseHeaders()).statusCode(200).build());
    }

    @OnError
    public void onError(@ParameterGroup(name="Error Response", showInDsl=true) @Expression(value=ExpressionSupport.NOT_SUPPORTED) @ParameterDsl(allowReferences=false) TaskErrorResponseParameterGroup errorResponse, Error error, SourceCallbackContext context, DistributedTraceContextManager traceContextManager) {
        Throwable t = ExceptionUtils.extractCauseOfType((Throwable)error.getCause(), MuleException.class).orElse(error.getCause());
        A2AErrorTypes errorType = ErrorUtils.getA2AErrorType(t).orElse(A2AErrorTypes.INTERNAL_ERROR);
        JsonRpcError rpcError = errorType.getJsonRpcCode().map(code -> new JsonRpcError((int)code, t.getMessage())).orElse(new JsonRpcError(A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().get(), t.getMessage()));
        int httpStatusCode = errorType.getHttpStatusCode();
        TracingUtils.traceResponseStatusCode(traceContextManager, httpStatusCode, LOGGER);
        this.recoverRequestContext(context).getResponseFuture().complete(RpcRequestContext.Response.builder().statusCode(httpStatusCode).error(rpcError).headers(errorResponse.getResponseHeaders()).build());
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        sourceResult.getResponseError().ifPresent(error -> LOGGER.error("<mcp:task-listener> at location {} failed to send response to client: {}", new Object[]{this.componentLocation.getLocation(), error.getDescription(), error.getCause()}));
    }

    public void onStop() {
        if (this.serverAgent != null) {
            this.serverAgent.stop();
            this.serverAgent = null;
        }
    }
}

