/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.tracing;

import com.mulesoft.connectors.a2a.internal.tracing.SpanCustomizer;
import java.net.URI;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundSpanCustomizer
extends SpanCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundSpanCustomizer.class);
    private static final String HTTP_URL = "http.url";
    private static final String NET_PEER_PORT = "net.peer.port";
    private static final String NET_PEER_NAME = "net.peer.name";
    private static final String SPAN_KIND_NAME = "CLIENT";
    private static final String PROTOCOL_VERSION_0_9 = "0.9";
    private static final String PROTOCOL_VERSION_1_0 = "1.0";
    private static final String PROTOCOL_VERSION_1_1 = "1.1";
    private final HttpRequest httpRequest;

    public OutboundSpanCustomizer(DistributedTraceContextManager traceContextManager, HttpRequest httpRequest) {
        super(traceContextManager);
        this.httpRequest = httpRequest;
    }

    @Override
    public void customizeSpan() {
        super.customizeSpan();
        try {
            this.traceContextManager.addCurrentSpanAttribute(HTTP_URL, this.getURI().toString());
            if (this.getURI().getPort() == -1) {
                this.traceContextManager.addCurrentSpanAttribute(NET_PEER_PORT, String.valueOf(this.getURI().toURL().getDefaultPort()));
            } else {
                this.traceContextManager.addCurrentSpanAttribute(NET_PEER_PORT, String.valueOf(this.getURI().getPort()));
            }
            this.traceContextManager.addCurrentSpanAttribute(NET_PEER_NAME, this.getURI().getHost());
        }
        catch (Throwable e) {
            LOGGER.warn("Error on setting the request span attributes", e);
        }
    }

    @Override
    public String getProtocol() {
        return this.httpRequest.getUri().getScheme().toUpperCase();
    }

    @Override
    public String getMethod() {
        return this.httpRequest.getMethod().toUpperCase();
    }

    @Override
    public String getFlavor() {
        return OutboundSpanCustomizer.getHttpProtocolVersionFrom(this.httpRequest.getProtocol());
    }

    @Override
    public URI getURI() {
        return this.httpRequest.getUri();
    }

    @Override
    protected String getSpanKind() {
        return SPAN_KIND_NAME;
    }

    private static String getHttpProtocolVersionFrom(HttpProtocol protocol) {
        if (protocol == null) {
            return null;
        }
        if (protocol.equals((Object)HttpProtocol.HTTP_0_9)) {
            return PROTOCOL_VERSION_0_9;
        }
        if (protocol.equals((Object)HttpProtocol.HTTP_1_0)) {
            return PROTOCOL_VERSION_1_0;
        }
        return PROTOCOL_VERSION_1_1;
    }
}

