/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card;

import com.mulesoft.connectors.a2a.api.model.card.AgentCapabilities;
import com.mulesoft.connectors.a2a.api.model.card.AgentProvider;
import com.mulesoft.connectors.a2a.api.model.card.AgentSkill;
import com.mulesoft.connectors.a2a.api.model.card.SecurityRequirement;
import com.mulesoft.connectors.a2a.api.model.card.SecurityScheme;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;

public class AgentCard {
    private static final List<String> DEFAULT_INPUT_MODES = List.of("text/plain");
    private static final List<String> DEFAULT_OUTPUT_MODES = List.of("text/plain");
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent Name")
    @Summary(value="The unique name that identifies this agent")
    private String name;
    @Parameter
    @Url
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent URL")
    @Summary(value="The URL endpoint where this agent can be accessed")
    private String url;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent Version")
    @Summary(value="The version of this agent implementation")
    private String version;
    @Parameter
    @Optional
    @Text
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent Description")
    @Summary(value="A detailed description of this agent's purpose and capabilities")
    private String description;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent Skills")
    @Summary(value="The list of skills that this agent can perform")
    @Placement(tab="Skills")
    private List<AgentSkill> skills;
    @Parameter
    @Optional
    @NullSafe
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent Capabilities")
    @Summary(value="The technical capabilities of this agent")
    @Placement(tab="Capabilities")
    private AgentCapabilities capabilities;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Agent Provider")
    @Summary(value="Information about the provider of this agent")
    @Placement(tab="Provider")
    private AgentProvider provider;
    @Parameter
    @Optional
    @Url
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Documentation URL")
    @Summary(value="The URL where documentation for this agent can be found")
    private String documentationUrl;
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Default Input Modes")
    @Summary(value="The default input modes supported by this agent (defaults to 'text' if not specified)")
    private List<String> defaultInputModes;
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Default Output Modes")
    @Summary(value="The default output modes supported by this agent (defaults to 'text' if not specified)")
    private List<String> defaultOutputModes;
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Security")
    @Placement(tab="Security")
    @Summary(value="Security requirements for contacting the agent")
    private List<SecurityRequirement> security;
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Security Schemes")
    @Summary(value="The security schemes available for this agent.")
    @Placement(tab="Security")
    private List<SecurityScheme> securitySchemes;
    private boolean supportsAuthenticatedExtendedCard;
    @Parameter
    @Optional
    @DisplayName(value="Icon URL")
    @Summary(value="A URL to an icon for the agent.")
    private String iconUrl;
    @Parameter
    @DisplayName(value="Protocol Version")
    @Summary(value="The A2A spec version on which agent is running.")
    private String protocolVersion;

    public AgentCard copy() {
        AgentCard copy = new AgentCard();
        copy.name = this.name;
        copy.url = this.url;
        copy.version = this.version;
        copy.description = this.description;
        if (this.skills != null) {
            copy.skills = this.skills.stream().map(AgentSkill::copy).toList();
        }
        copy.capabilities = this.capabilities != null ? this.capabilities.copy() : null;
        copy.provider = this.provider != null ? this.provider.copy() : null;
        copy.documentationUrl = this.documentationUrl;
        copy.defaultInputModes = this.defaultInputModes != null ? this.defaultInputModes : DEFAULT_INPUT_MODES;
        List<String> list = copy.defaultOutputModes = this.defaultOutputModes != null ? this.defaultOutputModes : DEFAULT_OUTPUT_MODES;
        if (this.security != null) {
            copy.security = this.security.stream().map(SecurityRequirement::copy).toList();
        }
        copy.supportsAuthenticatedExtendedCard = this.supportsAuthenticatedExtendedCard;
        copy.securitySchemes = this.securitySchemes != null ? this.securitySchemes.stream().map(SecurityScheme::copy).toList() : null;
        copy.iconUrl = this.iconUrl;
        copy.protocolVersion = this.protocolVersion;
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent name is required and cannot be null or empty");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent URL is required and cannot be null or empty");
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Agent URL must be a valid absolute URL", e);
        }
        this.url = url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent version is required and cannot be null or empty");
        }
        this.version = version;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public List<String> getDefaultInputModes() {
        return this.defaultInputModes == null || this.defaultInputModes.isEmpty() ? DEFAULT_INPUT_MODES : this.defaultInputModes;
    }

    public void setDefaultInputModes(List<String> defaultInputModes) {
        this.defaultInputModes = defaultInputModes;
    }

    public List<String> getDefaultOutputModes() {
        return this.defaultOutputModes == null || this.defaultOutputModes.isEmpty() ? DEFAULT_OUTPUT_MODES : this.defaultOutputModes;
    }

    public void setDefaultOutputModes(List<String> defaultOutputModes) {
        this.defaultOutputModes = defaultOutputModes;
    }

    public AgentProvider getProvider() {
        return this.provider;
    }

    public void setProvider(AgentProvider provider) {
        this.provider = provider;
    }

    public AgentCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(AgentCapabilities capabilities) {
        if (capabilities == null) {
            capabilities = new AgentCapabilities();
        }
        this.capabilities = capabilities;
    }

    public List<AgentSkill> getSkills() {
        return this.skills;
    }

    public void setSkills(List<AgentSkill> skills) {
        if (skills == null || skills.isEmpty()) {
            throw new IllegalArgumentException("Skills are required and must contain at least one skill");
        }
        this.skills = skills;
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRequirement> security) {
        this.security = security;
    }

    public boolean getSupportsAuthenticatedExtendedCard() {
        return this.supportsAuthenticatedExtendedCard;
    }

    public void setSupportsAuthenticatedExtendedCard(boolean supportsAuthenticatedExtendedCard) {
        this.supportsAuthenticatedExtendedCard = supportsAuthenticatedExtendedCard;
    }

    public List<SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(List<SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        if (protocolVersion == null || protocolVersion.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent protocol version is required and cannot be null or empty");
        }
        this.protocolVersion = protocolVersion;
    }

    public boolean equals(Object object) {
        if (object instanceof AgentCard) {
            AgentCard agentCard = (AgentCard)object;
            return Objects.equals(this.name, agentCard.name) && Objects.equals(this.url, agentCard.url) && Objects.equals(this.version, agentCard.version) && Objects.equals(this.description, agentCard.description) && Objects.equals(this.skills, agentCard.skills) && Objects.equals(this.capabilities, agentCard.capabilities) && Objects.equals(this.provider, agentCard.provider) && Objects.equals(this.documentationUrl, agentCard.documentationUrl) && Objects.equals(this.defaultInputModes, agentCard.defaultInputModes) && Objects.equals(this.defaultOutputModes, agentCard.defaultOutputModes) && Objects.equals(this.security, agentCard.security) && Objects.equals(this.supportsAuthenticatedExtendedCard, agentCard.supportsAuthenticatedExtendedCard) && Objects.equals(this.securitySchemes, agentCard.securitySchemes) && Objects.equals(this.iconUrl, agentCard.iconUrl) && Objects.equals(this.protocolVersion, agentCard.protocolVersion);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.version, this.description, this.skills, this.capabilities, this.provider, this.documentationUrl, this.defaultInputModes, this.defaultOutputModes, this.security, this.supportsAuthenticatedExtendedCard, this.securitySchemes, this.iconUrl, this.protocolVersion);
    }
}

