/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.api.model.card.security;

import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Flow;
import com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="Authorization Code Oauth2 Flows")
public class AuthorizationCodeOauth2Flows
extends Oauth2Flow {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Authorization URL")
    @Summary(value="The authorization URL to be used for this flow")
    private String authorizationUrl;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Token URL")
    @Summary(value="The token URL to be used for this flow")
    private String tokenUrl;
    private final String type = "authorizationCode";

    @Override
    public String getType() {
        return "authorizationCode";
    }

    @Override
    public AuthorizationCodeOauth2Flows copy() {
        AuthorizationCodeOauth2Flows copy = new AuthorizationCodeOauth2Flows();
        copy.authorizationUrl = this.authorizationUrl;
        copy.tokenUrl = this.tokenUrl;
        copy.setRefreshUrl(this.getRefreshUrl());
        if (this.getOauth2Scopes() != null) {
            copy.setOauth2Scopes(this.getOauth2Scopes().stream().map(Oauth2Scope::copy).collect(Collectors.toList()));
        }
        return copy;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AuthorizationCodeOauth2Flows) {
            AuthorizationCodeOauth2Flows authorizationCodeOauth2Flows = (AuthorizationCodeOauth2Flows)object;
            return super.equals(object) && Objects.equals(this.authorizationUrl, authorizationCodeOauth2Flows.authorizationUrl) && Objects.equals(this.tokenUrl, authorizationCodeOauth2Flows.tokenUrl) && Objects.equals(this.getOauth2Scopes(), authorizationCodeOauth2Flows.getOauth2Scopes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.authorizationUrl, this.tokenUrl);
    }
}

