/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.client.helper;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.api.model.transport.ResponseAttributes;
import com.mulesoft.connectors.a2a.internal.error.exception.AgentCardDiscoveryException;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentCardHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentCardHelper.class);

    public static AgentCard parseAgentCard(URI requestUri, String json, A2AProtocolSerializer serializer) throws AgentCardDiscoveryException {
        try {
            LOGGER.debug("Attempting to parse agent card JSON: {}", (Object)json);
            AgentCard agentCard = serializer.parseAgentCard(json);
            LOGGER.debug("Successfully parsed agent card: {}", (Object)agentCard);
            return agentCard;
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse agent card: {}", (Object)json, (Object)e);
            throw new AgentCardDiscoveryException.InvalidAgentCardException("Failed to parse agent card: " + e.getMessage(), requestUri, json, null);
        }
    }

    public static AgentCard handleAgentCardResponse(URI requestUri, Result<String, ResponseAttributes> result, A2AProtocolSerializer serializer) throws AgentCardDiscoveryException {
        try {
            ResponseAttributes attributes = (ResponseAttributes)result.getAttributes().orElseThrow(() -> new AgentCardDiscoveryException("missing response attributes", requestUri, null));
            int statusCode = attributes.getStatusCode();
            if (statusCode == HttpConstants.HttpStatus.OK.getStatusCode()) {
                return AgentCardHelper.parseAgentCard(requestUri, (String)result.getOutput(), serializer);
            }
            if (statusCode == HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()) {
                LOGGER.error("Agent card not found at {}", (Object)requestUri);
                throw new AgentCardDiscoveryException.NotFoundException(requestUri);
            }
            String reasonPhrase = attributes.getReasonPhrase();
            MultiMap<String, String> headersMultiMap = attributes.getHeaders();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (headersMultiMap != null) {
                headersMultiMap.forEach((name, values) -> headers.put((String)name, String.join((CharSequence)",", values)));
            }
            LOGGER.error("HTTP error {}: {} for URI {} with headers {}", new Object[]{statusCode, reasonPhrase, requestUri, headers});
            throw new AgentCardDiscoveryException.HttpErrorException(statusCode, reasonPhrase != null ? reasonPhrase : "Unknown error", requestUri, headers);
        }
        catch (AgentCardDiscoveryException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle agent card response", (Throwable)e);
            throw new AgentCardDiscoveryException("Failed to handle agent card response", requestUri, e);
        }
    }

    public static URI validateServerUrl(String serverUrl) throws AgentCardDiscoveryException {
        try {
            return new URI(serverUrl);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Request coming in server URL: {}", (Object)serverUrl);
            throw new AgentCardDiscoveryException("Invalid server URL: " + serverUrl, null, e);
        }
    }
}

