/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.error;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

public enum A2AErrorTypes implements ErrorTypeDefinition<A2AErrorTypes>
{
    JSON_RPC_ERROR,
    PARSE_ERROR(-32700, JSON_RPC_ERROR, 500),
    INVALID_REQUEST(-32600, JSON_RPC_ERROR, 400),
    METHOD_NOT_FOUND(-32601, JSON_RPC_ERROR, 404),
    INVALID_PARAMS(-32602, JSON_RPC_ERROR, 500),
    INTERNAL_ERROR(-32603, JSON_RPC_ERROR, 500),
    SERVER_ERROR(-32000, JSON_RPC_ERROR, 500),
    TASK_NOT_FOUND(-32001, JSON_RPC_ERROR, 404),
    TASK_ALREADY_COMPLETED(-32002, JSON_RPC_ERROR, 400),
    PUSH_NOTIFICATION_UNSUPPORTED(-32003, JSON_RPC_ERROR),
    REQUEST_TIMEOUT(null, null, 408),
    UNAUTHORIZED(null, null, 401),
    INVALID_AGENT_CARD(null, null, 400);

    private final Integer jsonRpcCode;
    private final A2AErrorTypes parent;
    private final int httpStatusCode;

    public static A2AErrorTypes fromRpcErrorCode(Integer errorCode) {
        for (A2AErrorTypes type : A2AErrorTypes.values()) {
            if (!Objects.equals(type.jsonRpcCode, errorCode)) continue;
            return type;
        }
        return INTERNAL_ERROR;
    }

    private A2AErrorTypes() {
        this(null, null, 500);
    }

    private A2AErrorTypes(Integer code, A2AErrorTypes parent) {
        this(code, parent, 500);
    }

    private A2AErrorTypes(Integer code, A2AErrorTypes parent, int httpStatusCode) {
        this.jsonRpcCode = code;
        this.parent = parent;
        this.httpStatusCode = httpStatusCode;
    }

    public Optional<Integer> getJsonRpcCode() {
        return Optional.ofNullable(this.jsonRpcCode);
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public boolean isJsonRpcError() {
        if (this == JSON_RPC_ERROR) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isJsonRpcError();
        }
        return false;
    }
}

