/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.error.exception;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionException;

public class AgentCardDiscoveryException
extends ConnectionException {
    private final URI requestUri;

    public AgentCardDiscoveryException(String message) {
        this(message, null, null);
    }

    public AgentCardDiscoveryException(String message, URI requestUri, Throwable cause) {
        super(message, cause);
        this.requestUri = requestUri;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public static class NotFoundException
    extends HttpErrorException {
        public NotFoundException(URI requestUri) {
            super(404, "Agent card not found at /.well-known/agent-card.json", requestUri, Collections.emptyMap());
        }
    }

    public static class TimeoutException
    extends AgentCardDiscoveryException {
        public TimeoutException(String message, URI requestUri, Throwable cause) {
            super("Connection timeout: " + message, requestUri, cause);
        }
    }

    public static class InvalidAgentCardException
    extends AgentCardDiscoveryException {
        private final String responseJson;

        public InvalidAgentCardException(String message, URI requestUri) {
            this(message, requestUri, null, null);
        }

        public InvalidAgentCardException(String message, URI requestUri, String responseJson) {
            this(message, requestUri, responseJson, null);
        }

        public InvalidAgentCardException(String message, URI requestUri, Throwable cause) {
            this(message, requestUri, null, cause);
        }

        public InvalidAgentCardException(String message, URI requestUri, String responseJson, Throwable cause) {
            super("Invalid agent card: " + message, requestUri, cause);
            this.responseJson = responseJson;
        }

        public String getResponseJson() {
            return this.responseJson;
        }
    }

    public static class HttpErrorException
    extends AgentCardDiscoveryException {
        private final int statusCode;
        private final Map<String, String> headers;

        public HttpErrorException(int statusCode, String message, URI requestUri, Map<String, String> headers) {
            super(String.format("HTTP error %d: %s", statusCode, message), requestUri, null);
            this.statusCode = statusCode;
            this.headers = headers != null ? new HashMap<String, String>(headers) : Collections.emptyMap();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

