/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.protocol;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.internal.error.exception.AgentCardDiscoveryException;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import com.mulesoft.connectors.a2a.internal.server.agent.response.MessageObject;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.util.IOUtils;

public class A2AProtocolSerializer
implements Initialisable {
    private static final DataType RESULT_DATA_TYPE = DataType.fromType(JsonRpcResult.class);
    private static final DataType AGENT_CARD_DATA_TYPE = DataType.fromType(AgentCard.class);
    private static final DataType PUSH_NOTIFICATION_CONFIG_DATA_TYPE = DataType.fromType(EffectivePushNotificationConfig.class);
    private static final DataType LIST_DATA_TYPE = DataType.fromType(List.class);
    @Inject
    private ExpressionManager expressionManager;
    private DwConverter requestMessageTransformer;
    private DwConverter responseMessageTransformer;
    private DwConverter resultParser;
    private DwConverter taskQueryParamsExtractor;
    private DwConverter taskHistoryTransformer;
    private DwConverter pushNotificationConfigResponseTransformer;
    private DwConverter pushNotificationConfigListResponseTransformer;
    private DwConverter agentCardReader;
    private DwConverter agentCardWriter;
    private DwConverter pushNotificationConfigReader;
    private DwConverter extractPushNotificationConfigReader;
    private DwConverter requestMessageExtractor;
    private DwConverter taskIdForPushNotificationExtractor;
    private DwConverter notificationConfigRequestIdExtractor;

    public String getJsonMessageFromResult(String json) {
        return this.responseMessageTransformer.evaluateAsString(json, DataType.JSON_STRING);
    }

    public JsonRpcResult parseResult(String json) {
        return (JsonRpcResult)this.resultParser.evaluate(json, RESULT_DATA_TYPE);
    }

    public String getJsonMessageFromRequest(String json) {
        return this.requestMessageTransformer.evaluateAsString(json, DataType.JSON_STRING);
    }

    public JsonRpcResult getTaskQueryParams(String params) {
        return (JsonRpcResult)this.taskQueryParamsExtractor.evaluate(params, RESULT_DATA_TYPE);
    }

    public String transformTaskHistoryResponse(String taskHistoryJson, int historyLength) {
        return this.taskHistoryTransformer.evaluateAsStringWithBinding(taskHistoryJson, DataType.JSON_STRING, (value, builder) -> {
            builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING));
            builder.addBinding("historyLength", new TypedValue((Object)historyLength, DataType.fromType(Integer.class)));
        });
    }

    public String transformPushNotificationConfigResponse(String taskId, EffectivePushNotificationConfig pushConfig) {
        Map<String, EffectivePushNotificationConfig> payload = Map.of("taskId", taskId, "pushConfig", pushConfig);
        return this.pushNotificationConfigResponseTransformer.evaluateAsString(payload, DataType.JSON_STRING);
    }

    public String transformPushNotificationConfigListResponse(String taskId, List<EffectivePushNotificationConfig> pushConfigs) {
        Map<String, List<EffectivePushNotificationConfig>> payload = Map.of("taskId", taskId, "pushConfigs", pushConfigs);
        return this.pushNotificationConfigListResponseTransformer.evaluateAsString(payload, DataType.JSON_STRING);
    }

    public MessageObject extractMessageFromParams(String paramsJson) {
        return (MessageObject)this.requestMessageExtractor.evaluate(paramsJson, DataType.fromType(MessageObject.class));
    }

    public String extractTaskIdForPushNotificationConfig(String paramsJson) {
        return (String)this.taskIdForPushNotificationExtractor.evaluate(paramsJson, DataType.fromType(String.class));
    }

    public String toAgentCardJson(AgentCard agentCard) throws AgentCardDiscoveryException.InvalidAgentCardException {
        if (agentCard == null) {
            throw new AgentCardDiscoveryException.InvalidAgentCardException("Agent card cannot be null", null);
        }
        return this.agentCardWriter.evaluateAsString(agentCard, DataType.JSON_STRING);
    }

    public AgentCard parseAgentCard(String json) {
        return (AgentCard)this.agentCardReader.evaluate(json, AGENT_CARD_DATA_TYPE);
    }

    public EffectivePushNotificationConfig parsePushNotificationConfig(String json) {
        return (EffectivePushNotificationConfig)this.pushNotificationConfigReader.evaluate(json, PUSH_NOTIFICATION_CONFIG_DATA_TYPE);
    }

    public String extractPushNotificationConfigJson(String fullParamsJson) {
        return this.extractPushNotificationConfigReader.evaluateAsString(fullParamsJson, DataType.JSON_STRING);
    }

    public JsonRpcResult getTaskPushNotificationConfigParams(String params) {
        return (JsonRpcResult)this.notificationConfigRequestIdExtractor.evaluate(params, RESULT_DATA_TYPE);
    }

    public void initialise() {
        this.responseMessageTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\nif (payload.result.kind == \"task\")\n    do {\n       var statusMessage = payload.result.status.message default {}\n       ---\n       {\n           taskId: payload.result.id,\n           contextId: payload.result.contextId,\n           messageId: statusMessage.messageId,\n           role: statusMessage.role,\n           parts: statusMessage.parts,\n           referenceTaskIds: statusMessage.referenceTaskIds,\n           kind: \"message\"\n       }\n   }\nelse {\n    // Handle Message Object response\n    taskId: payload.result.taskId,\n    contextId: payload.result.contextId,\n    role: payload.result.role,\n    parts: payload.result.parts,\n    messageId: payload.result.messageId,\n    referenceTaskIds: payload.result.referenceTaskIds default null,\n    kind: payload.result.kind\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.resultParser = new DwConverter("output application/java\n---\n{\n  result: if (payload.result.kind == \"task\") {\n            id: payload.result.id,\n            contextId: payload.result.contextId,\n            status: write(payload.result.status, \"json\") as String\n          } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.TaskObject\"}\n          else if (payload.result.kind == \"message\") {\n            taskId: payload.result.taskId,\n            messageId: payload.result.messageId\n          } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.MessageObject\"}\n          else\n            null,\n  resultJson: write(payload.result, \"json\") as String,\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.requestMessageTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\npayload.message\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.taskQueryParamsExtractor = new DwConverter("output application/java\n---\n{\n    result: {\n        id: payload.id,\n        historyLength: payload.historyLength default 0\n    } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.request.TaskQueryParams\"},\n    resultJson: write(payload, \"json\") as String\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.taskHistoryTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n    id: payload.task.id,\n    contextId: payload.task.contextId,\n    status: payload.task.status,\n    history: if (payload.history != null) do {\n        var minHistoryLength = min([historyLength, (payload.historyLength)])\n        ---\n        payload.history[(sizeOf(payload.history) - minHistoryLength) to (sizeOf(payload.history) - 1)]\n    } else [],\n    artifacts: payload.task.artifacts,\n    kind: payload.task.kind\n}\n", (value, builder) -> {
            builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING));
            builder.addBinding("historyLength", new TypedValue((Object)0, DataType.fromType(Integer.class)));
        });
        this.pushNotificationConfigResponseTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n    taskId: payload.taskId,\n    pushNotificationConfig: {\n        url: payload.pushConfig.url,\n        id: payload.pushConfig.id,\n        token: payload.pushConfig.token\n    }\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
        this.pushNotificationConfigListResponseTransformer = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\npayload.pushConfigs map (pushConfig) -> {\n    taskId: payload.taskId,\n    pushNotificationConfig: {\n        url: pushConfig.url,\n        id: pushConfig.id,\n        token: pushConfig.token\n    }\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
        this.pushNotificationConfigReader = new DwConverter("output application/java\n---\n{\n  url: payload.url,\n  id: uuid(),\n  token: payload.token default null,\n  additionalHeaders: null,\n  timeout: payload.timeout default 10000,\n  proxyConfig: null\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.extractPushNotificationConfigReader = new DwConverter("output application/json\n---\nif (payload.configuration != null and payload.configuration.pushNotificationConfig != null)\n  payload.configuration.pushNotificationConfig\nelse if (payload.pushNotificationConfig != null)\n  payload.pushNotificationConfig\nelse\n  null\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.agentCardReader = new DwConverter("output application/java\n---\n{\n  name: payload.name,\n  url: payload.url,\n  version: payload.version,\n  protocolVersion: payload.protocolVersion,\n  description: payload.description,\n  skills: payload.skills,\n  iconUrl: payload.iconUrl,\n  capabilities: if (payload.capabilities != null)\n    {\n      streaming: payload.capabilities.streaming default false,\n      pushNotifications: payload.capabilities.pushNotifications default false,\n      stateTransitionHistory: payload.capabilities.stateTransitionHistory default false,\n      extensions: if (payload.capabilities.extensions != null and payload.capabilities.extensions is Array)\n        payload.capabilities.extensions map (ext) ->\n          {\n            uri: ext.uri,\n            description: ext.description,\n            required: ext.required default false,\n            params: ext.params\n          } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.AgentExtension\"}\n      else\n        payload.capabilities.extensions\n    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.AgentCapabilities\"}\n  else\n    null,\n  provider: payload.provider,\n  documentationUrl: payload.documentationUrl,\n  defaultInputModes: payload.defaultInputModes,\n  defaultOutputModes: payload.defaultOutputModes,\n  supportsAuthenticatedExtendedCard: payload.supportsAuthenticatedExtendedCard default false,\n  security: if (payload.security != null and payload.security is Array)\n    payload.security flatMap (item) ->\n      item mapObject (value, key) ->\n        {\n          securitySchemeName: key,\n          scopes: value\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.SecurityRequirement\"}\n  else\n    payload.security,\n  securitySchemes: if (payload.securitySchemes != null and payload.securitySchemes is Object)\n    (payload.securitySchemes pluck (value, key) ->\n      if (value.\"type\" == \"http\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          schemeValue: value.scheme,\n          bearerFormat: value.bearerFormat\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.HttpSecurityScheme\"}\n      else if (value.\"type\" == \"apiKey\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          name: value.name,\n          inValue: value.\"in\"\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.ApiKeySecurityScheme\"}\n      else if (value.\"type\" == \"oauth2\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          flows: if (value.flows != null)\n            {\n              implicit: if (value.flows.implicit != null)\n                {\n                  authorizationUrl: value.flows.implicit.authorizationUrl,\n                  refreshUrl: value.flows.implicit.refreshUrl,\n                  oauth2Scopes: if (value.flows.implicit.scopes != null and value.flows.implicit.scopes is Object)\n                    (value.flows.implicit.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.ImplicitOauth2Flows\"}\n              else\n                null,\n              password: if (value.flows.password != null)\n                {\n                  tokenUrl: value.flows.password.tokenUrl,\n                  refreshUrl: value.flows.password.refreshUrl,\n                  oauth2Scopes: if (value.flows.password.scopes != null and value.flows.password.scopes is Object)\n                    (value.flows.password.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.PasswordOauth2Flows\"}\n              else\n                null,\n              clientCredentials: if (value.flows.clientCredentials != null)\n                {\n                  tokenUrl: value.flows.clientCredentials.tokenUrl,\n                  refreshUrl: value.flows.clientCredentials.refreshUrl,\n                  oauth2Scopes: if (value.flows.clientCredentials.scopes != null and value.flows.clientCredentials.scopes is Object)\n                    (value.flows.clientCredentials.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.ClientCredentialsOauth2Flows\"}\n              else\n                null,\n              authorizationCode: if (value.flows.authorizationCode != null)\n                {\n                  authorizationUrl: value.flows.authorizationCode.authorizationUrl,\n                  tokenUrl: value.flows.authorizationCode.tokenUrl,\n                  refreshUrl: value.flows.authorizationCode.refreshUrl,\n                  oauth2Scopes: if (value.flows.authorizationCode.scopes != null and value.flows.authorizationCode.scopes is Object)\n                    (value.flows.authorizationCode.scopes pluck (value, key) ->\n                    {\n                      name: key,\n                      description: value\n                    } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Scope\"}\n                    ) filter (scopes) -> scopes != null\n                    else\n                      null\n                } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.AuthorizationCodeOauth2Flows\"}\n              else\n                null\n            } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2Flows\"}\n          else\n            null\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.Oauth2SecurityScheme\"}\n      else if (value.\"type\" == \"openIdConnect\")\n        {\n          securitySchemeName: key,\n          description: value.description,\n          openIdConnectUrl: value.openIdConnectUrl\n        } as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.security.OpenIdConnectSecurityScheme\"}\n      else\n        // Skip unsupported security scheme types\n        null\n      ) filter (item) -> item != null\n  else\n    payload.securitySchemes\n} as Object {class: \"com.mulesoft.connectors.a2a.api.model.card.AgentCard\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.agentCardWriter = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n  name: payload.name,\n  url: payload.url,\n  version: payload.version,\n  protocolVersion: payload.protocolVersion,\n  description: payload.description,\n  skills: payload.skills,\n  iconUrl: payload.iconUrl,\n  capabilities: if (payload.capabilities != null)\n    {\n      streaming: payload.capabilities.streaming,\n      pushNotifications: payload.capabilities.pushNotifications,\n      stateTransitionHistory: payload.capabilities.stateTransitionHistory,\n      extensions: if (payload.capabilities.extensions != null and payload.capabilities.extensions is Array)\n        payload.capabilities.extensions map (ext) ->\n          {\n            uri: ext.uri,\n            description: ext.description,\n            required: ext.required,\n            params: ext.params\n          }\n      else\n        payload.capabilities.extensions\n    }\n  else\n    null,\n  provider: payload.provider,\n  documentationUrl: payload.documentationUrl,\n  defaultInputModes: payload.defaultInputModes,\n  defaultOutputModes: payload.defaultOutputModes,\n  supportsAuthenticatedExtendedCard: payload.supportsAuthenticatedExtendedCard,\n  security: if (payload.security != null and payload.security is Array)\n    payload.security map (item) ->\n      { (item.securitySchemeName): item.scopes }\n  else\n    payload.security,\n  securitySchemes: if (payload.securitySchemes != null and payload.securitySchemes is Array)\n    (payload.securitySchemes map (item) ->\n      {\n        (item.securitySchemeName): if (item.\"type\" == \"http\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            scheme: item.schemeValue,\n            bearerFormat: item.bearerFormat\n          }\n        else if (item.\"type\" == \"apiKey\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            name: item.name,\n            \"in\": item.inValue\n          }\n        else if (item.\"type\" == \"oauth2\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            flows: if (item.flows != null)\n              {\n                implicit: if (item.flows.implicit != null)\n                  {\n                    authorizationUrl: item.flows.implicit.authorizationUrl,\n                    refreshUrl: item.flows.implicit.refreshUrl,\n                    scopes: if (item.flows.implicit.oauth2Scopes != null and item.flows.implicit.oauth2Scopes is Array)\n                      (item.flows.implicit.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.implicit.oauth2Scopes\n                  }\n                else\n                  null,\n                password: if (item.flows.password != null)\n                  {\n                    tokenUrl: item.flows.password.tokenUrl,\n                    refreshUrl: item.flows.password.refreshUrl,\n                    scopes: if (item.flows.password.oauth2Scopes != null and item.flows.password.oauth2Scopes is Array)\n                      (item.flows.password.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.password.oauth2Scopes\n                  }\n                else\n                  null,\n                clientCredentials: if (item.flows.clientCredentials != null)\n                  {\n                    tokenUrl: item.flows.clientCredentials.tokenUrl,\n                    refreshUrl: item.flows.clientCredentials.refreshUrl,\n                    scopes: if (item.flows.clientCredentials.oauth2Scopes != null and item.flows.clientCredentials.oauth2Scopes is Array)\n                      (item.flows.clientCredentials.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.clientCredentials.oauth2Scopes\n                  }\n                else\n                  null,\n                authorizationCode: if (item.flows.authorizationCode != null)\n                  {\n                    authorizationUrl: item.flows.authorizationCode.authorizationUrl,\n                    tokenUrl: item.flows.authorizationCode.tokenUrl,\n                    refreshUrl: item.flows.authorizationCode.refreshUrl,\n                    scopes: if (item.flows.authorizationCode.oauth2Scopes != null and item.flows.authorizationCode.oauth2Scopes is Array)\n                      (item.flows.authorizationCode.oauth2Scopes map (scope) ->\n                        { (scope.name): scope.description }) reduce ((item, accumulator) -> accumulator ++ item)\n                    else\n                      item.flows.authorizationCode.oauth2Scopes\n                  }\n                else\n                  null\n              }\n            else\n              null\n          }\n        else if (item.\"type\" == \"openIdConnect\")\n          {\n            \"type\": item.\"type\",\n            description: item.description,\n            openIdConnectUrl: item.openIdConnectUrl\n          }\n        else\n          item\n      }) reduce (acc, item) -> acc ++ item\n  else\n    payload.securitySchemes\n}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.fromObject((Object)value))));
        this.requestMessageExtractor = new DwConverter("output application/java\n---\nif (payload.message != null) {\n  taskId: payload.message.taskId default uuid(),\n  contextId: payload.message.contextId default uuid(),\n  messageId: payload.message.messageId default uuid(),\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.MessageObject\"}\nelse\n  null\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.taskIdForPushNotificationExtractor = new DwConverter("output application/java\n---\nif (payload.taskId != null and payload.taskId != \"\")\n  payload.taskId\nelse\n  null\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
        this.notificationConfigRequestIdExtractor = new DwConverter("output application/java\n---\n{\n    result: if (payload.pushNotificationConfigId != null) {\n        id: payload.id,\n        pushNotificationConfigId: payload.pushNotificationConfigId default null\n    } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.request.TaskQueryParams\"}\n    else {\n      id: payload.id\n    } as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.request.TaskIdParams\"},\n    resultJson: write(payload, \"json\") as String\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult\"}\n", (value, builder) -> builder.addBinding("payload", new TypedValue(value, DataType.JSON_STRING)));
    }

    private class DwConverter {
        private final CompiledExpression expression;
        private final BiConsumer<Object, BindingContext.Builder> bindingConfigurer;

        private DwConverter(String expression, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this(expression, null, bindingConfigurer);
        }

        private DwConverter(String expression, Object defaultBindingValue, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this.bindingConfigurer = bindingConfigurer;
            this.expression = A2AProtocolSerializer.this.expressionManager.compile(expression, this.bind(defaultBindingValue));
        }

        private BindingContext bind(Object value) {
            BindingContext.Builder builder = BindingContext.builder();
            this.bindingConfigurer.accept(value, builder);
            return builder.build();
        }

        private <T> T evaluate(Object value, DataType expected) {
            try (ExpressionManagerSession session = A2AProtocolSerializer.this.expressionManager.openSession(this.bind(value));){
                Object object = session.evaluate(this.expression, expected).getValue();
                return (T)object;
            }
        }

        private String evaluateAsString(Object value, DataType expected) {
            CursorStreamProvider provider = (CursorStreamProvider)this.evaluate(value, expected);
            return IOUtils.toString((InputStream)((InputStream)provider.openCursor()));
        }

        private String evaluateAsStringWithBinding(String value, DataType expected, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            BindingContext.Builder builder = BindingContext.builder();
            bindingConfigurer.accept(value, builder);
            try (ExpressionManagerSession session = A2AProtocolSerializer.this.expressionManager.openSession(builder.build());){
                TypedValue result = session.evaluate(this.expression, expected);
                CursorStreamProvider provider = (CursorStreamProvider)result.getValue();
                String string = IOUtils.toString((InputStream)((InputStream)provider.openCursor()));
                return string;
            }
        }
    }
}

