/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.protocol;

import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.util.IOUtils;

public class JsonRpcSerializer
implements Initialisable {
    private static final DataType JSON_STREAM_DATA_TYPE = DataType.builder().type(InputStream.class).mediaType(MediaType.JSON).build();
    private static final DataType JSON_RESPONSE_ERROR_DATA_TYPE = DataType.fromType(JsonRpcError.class);
    private static final DataType JSON_REQUEST_DATA_TYPE = DataType.fromType(JsonRpcRequest.class);
    public static final String PAYLOAD = "payload";
    private final AtomicLong idGenerator = new AtomicLong(0L);
    @Inject
    private ExpressionManager expressionManager;
    private DwConverter jsonRequestWriter;
    private DwConverter jsonResponseWriter;
    private DwConverter jsonErrorResponseWriter;
    private DwConverter responseResultReader;
    private DwConverter errorResponseReader;
    private DwConverter jsonWriter;
    private DwConverter jsonRpcRequestReader;

    public InputStream writeJsonRequest(String method, Object params) {
        Map<String, Object> request = Map.of("id", Long.valueOf(this.idGenerator.incrementAndGet()).toString(), "method", method, "params", params);
        CursorStreamProvider provider = (CursorStreamProvider)this.jsonRequestWriter.evaluate(request, JSON_STREAM_DATA_TYPE);
        return (InputStream)provider.openCursor();
    }

    public String writeJsonResponse(Object id, InputStream result) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("id", id);
        response.put("result", result);
        return this.jsonResponseWriter.evaluateAsString(response, DataType.JSON_STRING);
    }

    public String createPushNotificationSubmittedResponse(String id, String taskId) {
        String contextId = UUID.randomUUID().toString();
        Map<String, String> status = Map.of("state", "submitted", "timestamp", Instant.now().toString());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("id", taskId);
        resultMap.put("contextId", contextId);
        resultMap.put("status", status);
        String responseBody = this.writeJsonResponse(id, new ByteArrayInputStream(this.toJson(resultMap).getBytes()));
        return responseBody;
    }

    public String writeJsonErrorResponse(Object id, int code, String message, Object data) {
        if (message == null || message.trim().isEmpty()) {
            throw new IllegalArgumentException("Error message must not be null or empty");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("id", id);
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("code", code);
        error.put("message", message);
        if (data != null) {
            error.put("data", data);
        }
        response.put("error", error);
        return this.jsonErrorResponseWriter.evaluateAsString(response, DataType.JSON_STRING);
    }

    public String writeJsonErrorResponse(Object id, int code, String message) {
        return this.writeJsonErrorResponse(id, code, message, null);
    }

    public String toJson(Object object) {
        return this.jsonWriter.evaluateAsString(object, DataType.JSON_STRING);
    }

    public JsonRpcRequest parseRpcRequest(InputStream inputStream) {
        return (JsonRpcRequest)this.jsonRpcRequestReader.evaluate(inputStream, JSON_REQUEST_DATA_TYPE);
    }

    public String getJsonResponseResult(String json) {
        return this.responseResultReader.evaluateAsString(json, DataType.JSON_STRING);
    }

    public JsonRpcError getJsonResponseError(String json) {
        return (JsonRpcError)this.errorResponseReader.evaluate(json, JSON_RESPONSE_ERROR_DATA_TYPE);
    }

    public void initialise() {
        this.jsonWriter = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\npayload\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.jsonRequestWriter = new DwConverter("output application/json skipNullOn=\"everywhere\"\n---\n{\n  jsonrpc: \"2.0\",\n  id: payload.id,\n  method: payload.method,\n  params: read(payload.params, \"application/json\")\n}", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.responseResultReader = new DwConverter("output application/java\n---\npayload.result\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.JSON_STRING)));
        this.errorResponseReader = new DwConverter("output application/java\n---\nif (payload.error != null)\n  payload.error as Object {class: \"com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError\"}\nelse\n  null\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.JSON_STRING)));
        this.jsonRpcRequestReader = new DwConverter("output application/java\n---\n{\n  id: if (payload.id? == true) payload.id else \"MISSING_ID\",\n  method: payload.method,\n  params: write(payload.params, \"json\") as String\n} as Object {class: \"com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest\"}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, JSON_STREAM_DATA_TYPE)));
        this.jsonResponseWriter = new DwConverter("output application/json\n---\n{\n  jsonrpc: \"2.0\",\n  id: payload.id,\n  result: read(payload.result, \"json\")\n}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
        this.jsonErrorResponseWriter = new DwConverter("output application/json\n---\n{\n  jsonrpc: \"2.0\",\n  id: payload.id,\n  error: {\n    code: payload.error.code,\n    message: payload.error.message,\n    data: payload.error.data\n  }\n}\n", (value, builder) -> builder.addBinding(PAYLOAD, new TypedValue(value, DataType.fromObject((Object)value))));
    }

    private class DwConverter {
        private final CompiledExpression expression;
        private final BiConsumer<Object, BindingContext.Builder> bindingConfigurer;

        private DwConverter(String expression, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this(expression, null, bindingConfigurer);
        }

        private DwConverter(String expression, Object defaultBindingValue, BiConsumer<Object, BindingContext.Builder> bindingConfigurer) {
            this.bindingConfigurer = bindingConfigurer;
            this.expression = JsonRpcSerializer.this.expressionManager.compile(expression, this.bind(defaultBindingValue));
        }

        private BindingContext bind(Object value) {
            BindingContext.Builder builder = BindingContext.builder();
            this.bindingConfigurer.accept(value, builder);
            return builder.build();
        }

        private <T> T evaluate(Object value, DataType expected) {
            try (ExpressionManagerSession session = JsonRpcSerializer.this.expressionManager.openSession(this.bind(value));){
                Object object = session.evaluate(this.expression, expected).getValue();
                return (T)object;
            }
        }

        private String evaluateAsString(Object value, DataType expected) {
            CursorStreamProvider provider = (CursorStreamProvider)this.evaluate(value, expected);
            return IOUtils.toString((InputStream)((InputStream)provider.openCursor()));
        }
    }
}

